/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.finalize;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MethodInvoker;

public class InvokeFinalizerTask
extends ViewLifecycleTaskBase<Component> {
    private final Logger LOG = LoggerFactory.getLogger(InvokeFinalizerTask.class);

    public InvokeFinalizerTask() {
        super(Component.class);
    }

    @Override
    protected void performLifecycleTask() {
        List<Object> additionalArguments;
        Component component = (Component)this.getElementState().getElement();
        String finalizeMethodToCall = component.getFinalizeMethodToCall();
        MethodInvokerConfig finalizeMethodInvoker = component.getFinalizeMethodInvoker();
        if (StringUtils.isBlank((String)finalizeMethodToCall) && finalizeMethodInvoker == null) {
            return;
        }
        if (finalizeMethodInvoker == null) {
            finalizeMethodInvoker = new MethodInvoker();
        }
        if (StringUtils.isBlank((String)finalizeMethodInvoker.getTargetMethod())) {
            finalizeMethodInvoker.setTargetMethod(finalizeMethodToCall);
        }
        if (finalizeMethodInvoker.getTargetClass() == null && finalizeMethodInvoker.getTargetObject() == null) {
            finalizeMethodInvoker.setTargetObject(ViewLifecycle.getHelper());
        }
        if ((additionalArguments = component.getFinalizeMethodAdditionalArguments()) == null) {
            additionalArguments = new ArrayList<Object>();
        }
        Object[] arguments = new Object[2 + additionalArguments.size()];
        arguments[0] = component;
        arguments[1] = ViewLifecycle.getModel();
        int argumentIndex = 1;
        for (Object argument : additionalArguments) {
            arguments[++argumentIndex] = argument;
        }
        finalizeMethodInvoker.setArguments(arguments);
        try {
            this.LOG.debug("Invoking finalize method: " + finalizeMethodInvoker.getTargetMethod() + " for component: " + component.getId());
            finalizeMethodInvoker.prepare();
            Class<?> methodReturnType = finalizeMethodInvoker.getPreparedMethod().getReturnType();
            if (StringUtils.equals((String)"void", (String)methodReturnType.getName())) {
                finalizeMethodInvoker.invoke();
            } else {
                String renderOutput = (String)finalizeMethodInvoker.invoke();
                component.setSelfRendered(true);
                component.setRenderedHtmlOutput(renderOutput);
            }
        }
        catch (Exception e) {
            this.LOG.error("Error invoking finalize method for component: " + component.getId(), (Throwable)e);
            throw new RuntimeException("Error invoking finalize method for component: " + component.getId(), e);
        }
    }
}

