/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;

public class ViewIndex
implements Serializable {
    private static final long serialVersionUID = 4700818801272201371L;
    private static final Logger LOG = Logger.getLogger(ViewIndex.class);
    private Map<String, Component> index = new HashMap<String, Component>();
    private Map<String, DataField> dataFieldIndex = new HashMap<String, DataField>();
    private Map<String, CollectionGroup> collectionsIndex = new HashMap<String, CollectionGroup>();
    private Map<String, LifecycleElement> lifecycleElementsByPath = new HashMap<String, LifecycleElement>();
    private Set<String> assignedIds = new HashSet<String>();

    protected void clearIndex(View view) {
        this.index = new HashMap<String, Component>();
        this.dataFieldIndex = new HashMap<String, DataField>();
        this.collectionsIndex = new HashMap<String, CollectionGroup>();
        this.lifecycleElementsByPath = new HashMap<String, LifecycleElement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexComponent(Component component) {
        Map<String, LifecycleElement> map;
        Container container;
        if (component == null) {
            return;
        }
        Map<String, LifecycleElement> map2 = this.index;
        synchronized (map2) {
            this.index.put(component.getId(), component);
        }
        map2 = this.lifecycleElementsByPath;
        synchronized (map2) {
            this.lifecycleElementsByPath.put(component.getViewPath(), component);
        }
        if (component instanceof Container && (container = (Container)component).getLayoutManager() != null) {
            map = this.lifecycleElementsByPath;
            synchronized (map) {
                this.lifecycleElementsByPath.put(container.getLayoutManager().getViewPath(), container.getLayoutManager());
            }
        }
        if (component instanceof DataField) {
            DataField field = (DataField)component;
            map = this.dataFieldIndex;
            synchronized (map) {
                this.dataFieldIndex.put(field.getBindingInfo().getBindingPath(), field);
            }
        }
        if (component instanceof CollectionGroup) {
            CollectionGroup collectionGroup = (CollectionGroup)component;
            map = this.collectionsIndex;
            synchronized (map) {
                this.collectionsIndex.put(collectionGroup.getBindingInfo().getBindingPath(), collectionGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean observeAssignedId(String id) {
        if (this.assignedIds.contains(id)) {
            return false;
        }
        Set<String> set = this.assignedIds;
        synchronized (set) {
            return this.assignedIds.add(id);
        }
    }

    public Component getComponentById(String id) {
        return this.index.get(id);
    }

    public DataField getDataFieldByPath(String propertyPath) {
        return this.dataFieldIndex.get(propertyPath);
    }

    public DataField getDataFieldByPropertyName(String propertyName) {
        DataField dataField = null;
        for (DataField field : this.dataFieldIndex.values()) {
            if (!StringUtils.equals((String)propertyName, (String)field.getPropertyName())) continue;
            dataField = field;
            break;
        }
        return dataField;
    }

    public Map<String, LifecycleElement> getLifecycleElementsByPath() {
        return this.lifecycleElementsByPath;
    }

    public LifecycleElement getLifecycleElementByPath(String path) {
        if (this.lifecycleElementsByPath != null && this.lifecycleElementsByPath.containsKey(path)) {
            return this.lifecycleElementsByPath.get(path);
        }
        return null;
    }

    public Map<String, DataField> getDataFieldIndex() {
        return this.dataFieldIndex;
    }

    public Map<String, CollectionGroup> getCollectionsIndex() {
        return this.collectionsIndex;
    }

    public CollectionGroup getCollectionGroupByPath(String collectionPath) {
        return this.collectionsIndex.get(collectionPath);
    }

    public ViewIndex copy() {
        ViewIndex viewIndexCopy = new ViewIndex();
        if (this.index != null) {
            HashMap<String, Component> indexCopy = new HashMap<String, Component>();
            for (Map.Entry<String, Component> entry : this.index.entrySet()) {
                if (entry.getValue() instanceof View) {
                    LOG.warn((Object)("View reference at " + entry));
                    continue;
                }
                indexCopy.put(entry.getKey(), (Component)CopyUtils.copy(entry.getValue()));
            }
            viewIndexCopy.index = indexCopy;
        }
        if (this.dataFieldIndex != null) {
            HashMap<String, DataField> dataFieldIndexCopy = new HashMap<String, DataField>();
            for (Map.Entry<String, Component> entry : this.dataFieldIndex.entrySet()) {
                dataFieldIndexCopy.put(entry.getKey(), (DataField)CopyUtils.copy(entry.getValue()));
            }
            viewIndexCopy.dataFieldIndex = dataFieldIndexCopy;
        }
        if (this.collectionsIndex != null) {
            HashMap<String, CollectionGroup> collectionsIndexCopy = new HashMap<String, CollectionGroup>();
            for (Map.Entry<String, Component> entry : this.collectionsIndex.entrySet()) {
                collectionsIndexCopy.put(entry.getKey(), (CollectionGroup)CopyUtils.copy(entry.getValue()));
            }
            viewIndexCopy.collectionsIndex = collectionsIndexCopy;
        }
        return viewIndexCopy;
    }
}

