/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.framework.ManualContextProvider;
import org.kuali.rice.krms.framework.TermResolverMock;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.AgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicAgenda;
import org.kuali.rice.krms.framework.engine.BasicAgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicContext;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.kuali.rice.krms.framework.engine.ComparableTermBasedProposition;
import org.kuali.rice.krms.framework.engine.CompoundProposition;
import org.kuali.rice.krms.framework.engine.Context;
import org.kuali.rice.krms.framework.engine.ContextProvider;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.ProviderBasedEngine;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperatorServiceImpl;

public class KRMSTest {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private ComparisonOperator operatorGreaterThan;
    private ComparisonOperator operatorLessThan;
    private static final Term totalCostTerm = new Term("totalCost");
    private static final TermResolver<Integer> testResolver = new TermResolverMock<Integer>(totalCostTerm.getName(), 1);

    @Before
    public void setUp() {
        this.operatorGreaterThan = ComparisonOperator.GREATER_THAN;
        this.operatorGreaterThan.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        this.operatorLessThan = ComparisonOperator.LESS_THAN;
        this.operatorLessThan.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
    }

    @Test
    public void compoundPropositionTest() {
        ComparableTermBasedProposition prop1 = new ComparableTermBasedProposition(this.operatorGreaterThan, totalCostTerm, (Object)1);
        ComparableTermBasedProposition prop2 = new ComparableTermBasedProposition(this.operatorLessThan, totalCostTerm, (Object)1000);
        ComparableTermBasedProposition prop3 = new ComparableTermBasedProposition(this.operatorGreaterThan, totalCostTerm, (Object)1000);
        CompoundProposition compoundProp1 = new CompoundProposition(LogicalOperator.AND, Arrays.asList(prop1, prop2, prop3));
        BasicRule rule = new BasicRule("InBetween", (Proposition)compoundProp1, null);
        BasicAgendaTree agendaTree = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule)});
        BasicAgenda agenda = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree);
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("docTypeName", "Proposal");
        ArrayList<TermResolver<Integer>> testResolvers = new ArrayList<TermResolver<Integer>>();
        testResolvers.add(testResolver);
        BasicContext context = new BasicContext(Arrays.asList(agenda), testResolvers);
        ManualContextProvider contextProvider = new ManualContextProvider((Context)context);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Event", "test"));
        ProviderBasedEngine engine = new ProviderBasedEngine();
        engine.setContextProvider((ContextProvider)contextProvider);
        ExecutionOptions executionOptions = new ExecutionOptions().setFlag(ExecutionFlag.LOG_EXECUTION, true);
        EngineResults results = engine.execute(selectionCriteria, Facts.EMPTY_FACTS, executionOptions);
        Assert.assertNotNull((Object)results);
    }
}

