/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolutionEngine;
import org.kuali.rice.krms.api.engine.TermResolutionException;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.framework.engine.TermResolutionEngineImpl;
import org.springframework.util.CollectionUtils;

public class TermResolutionEngineTest {
    private static final Logger LOG = Logger.getLogger(TermResolutionEngineTest.class);
    private TermResolutionEngine termResolutionEngine = null;

    @Before
    public void setUp() {
        this.termResolutionEngine = new TermResolutionEngineImpl();
    }

    @Test
    public void testNoResolution() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("A");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("A");
    }

    @Test
    public void testSimpleResolution() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("A");
        testHelper.addResolver("B", "A");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("B");
    }

    @Test
    public void testTwoStepResolution() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("A");
        testHelper.addResolver("B", "A");
        testHelper.addResolver("C", "B");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("C");
    }

    @Test
    public void testForkingResolution() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("A", "Z");
        testHelper.addResolver("D", "B", "C");
        testHelper.addResolver("C", "Z");
        testHelper.addResolver("B", "A");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("D");
    }

    @Test
    public void testMultipleValidPaths() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("A", "Z");
        testHelper.addResolver("D", "B", "C");
        testHelper.addResolver("C", "Z");
        testHelper.addResolver("B", "A");
        testHelper.addResolver("D", "A");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("D");
    }

    @Test
    public void testDiamond() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("A");
        testHelper.addResolver("D", "B", "C");
        testHelper.addResolver("C", "A");
        testHelper.addResolver("B", "A");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("D");
    }

    @Test
    public void testComplexPath() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("Q", "R", "S");
        testHelper.addResolver("A", "B", "F");
        testHelper.addResolver("A", "Z");
        testHelper.addResolver("B", "D");
        testHelper.addResolver("B", "C");
        testHelper.addResolver("C", "S");
        testHelper.addResolver("D", "E");
        testHelper.addResolver("E", "S");
        testHelper.addResolver("F", "G", "Q");
        testHelper.addResolver("G", "R");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("A");
    }

    @Test
    public void testCycle() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addResolver("D", "C");
        testHelper.addResolver("C", "D");
        testHelper.logScenarioDescription();
        testHelper.assertException("D");
    }

    @Test
    public void testUnreachableTerm() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addResolver("D", "C");
        testHelper.addResolver("C", "B");
        testHelper.logScenarioDescription();
        testHelper.assertException("D");
    }

    @Test
    public void testRedHerringPath() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("Q");
        testHelper.addResolver("A", "B");
        testHelper.addResolver("B", "C");
        testHelper.addResolver("B", "D");
        testHelper.addResolver("D", "Q");
        testHelper.logScenarioDescription();
        testHelper.assertSuccess("A");
    }

    @Test
    public void testResolveParamaterizedTerm() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("Q");
        testHelper.addResolver(1, "A", new String[]{"param"}, new String[]{"B"});
        testHelper.addResolver("B", "Q");
        testHelper.logScenarioDescription();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param", "value");
        testHelper.assertSuccess(testHelper.getTerm("A", params));
        testHelper.assertException(new Term("A"));
    }

    @Test
    public void testIntermediateParamaterizedTerm() {
        TestScenarioHelper testHelper = new TestScenarioHelper(this.termResolutionEngine);
        testHelper.addGivens("Q");
        testHelper.addResolver(1, "A", new String[]{"foo"}, new String[]{"B"});
        testHelper.addResolver(1, "B", new String[]{"bar"}, new String[]{"Q"});
        testHelper.logScenarioDescription();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("foo", "foovalue");
        testHelper.assertException(testHelper.getTerm("A", params));
    }

    @Test
    public void testShortestPath() {
        WhiteBoxTermResolutionEngineImpl whiteBoxTermResolutionService = new WhiteBoxTermResolutionEngineImpl();
        TestScenarioHelper testHelper = new TestScenarioHelper((TermResolutionEngine)whiteBoxTermResolutionService);
        testHelper.addGivens("Q");
        testHelper.addResolver(3, "A", "Q");
        testHelper.addResolver("A", "B");
        testHelper.addResolver("B", "C");
        testHelper.addResolver("C", "D");
        testHelper.addResolver("D", "Q");
        testHelper.logScenarioDescription();
        List<TermResolutionEngineImpl.TermResolverKey> plan = whiteBoxTermResolutionService.buildTermResolutionPlan("A");
        LOG.info((Object)("resolutionPlan: " + StringUtils.join(plan, (String)", ") + " <-- should be length 1!"));
        Assert.assertTrue((String)"didn't choose the shortest resolution path (of length 1)", (plan.size() == 1 ? 1 : 0) != 0);
    }

    private static class TestScenarioHelper {
        private final TermResolutionEngine ars;
        private List<String> givens = new LinkedList<String>();
        private List<String> resolvers = new LinkedList<String>();

        public TestScenarioHelper(TermResolutionEngine tre) {
            this.ars = tre;
        }

        public void addGivens(String ... names) {
            for (String name : names) {
                this.ars.addTermValue(new Term(name, null), (Object)this.getResult(name));
                this.givens.add(name);
            }
        }

        public String getResult(String name) {
            return this.getResult(new Term(name, null));
        }

        public String getResult(Term term) {
            return term.getName() + "-result";
        }

        public Term getTerm(String name, Map<String, String> params) {
            return new Term(name, params);
        }

        public void addResolver(String out, String ... prereqs) {
            this.addResolver(1, out, prereqs);
        }

        public void addResolver(int cost, String out, String ... prereqs) {
            this.addResolver(1, out, (String[])null, prereqs);
        }

        public void addResolver(int cost, String out, String[] params, String ... prereqs) {
            String[] prereqTerms = new String[prereqs.length];
            for (int i = 0; i < prereqs.length; ++i) {
                prereqTerms[i] = prereqs[i];
            }
            Set<String> paramSet = Collections.emptySet();
            if (params != null) {
                paramSet = new HashSet<String>(Arrays.asList(params));
            }
            this.ars.addTermResolver(new TermResolverMock<String>(out, paramSet, this.getResult(out), cost, prereqTerms));
            this.resolvers.add("(" + out + " <- " + StringUtils.join((Object[])prereqs, (String)",") + ")");
        }

        public void logScenarioDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("givens: " + StringUtils.join(this.givens.iterator(), (String)", ") + "\n\n");
            sb.append("resolvers:\n----------------------\n");
            if (this.resolvers == null || this.resolvers.size() == 0) {
                sb.append("none");
            } else {
                sb.append(StringUtils.join(this.resolvers.iterator(), (String)"\n"));
            }
            sb.append("\n");
            LOG.info((Object)("Test Scenario:\n\n" + sb.toString()));
        }

        public void assertSuccess(String toResolve) {
            this.assertSuccess(new Term(toResolve, null));
        }

        public void assertSuccess(Term toResolve) {
            LOG.info((Object)("Testing resolution of " + toResolve));
            try {
                Assert.assertEquals((String)this.getResult(toResolve), (String)((String)this.ars.resolveTerm(toResolve)));
                LOG.info((Object)"Success!");
            }
            catch (TermResolutionException e) {
                Assert.fail((String)"Should resolve the termName w/o exceptions");
            }
        }

        public void assertException(String toResolve) {
            this.assertException(new Term(toResolve, null));
        }

        public void assertException(Term toResolve) {
            LOG.info((Object)("Testing resolution of " + toResolve));
            try {
                this.ars.resolveTerm(toResolve);
                Assert.fail((String)"Should throw TermResolutionException");
            }
            catch (TermResolutionException e) {
                LOG.info((Object)("Success! threw " + (Object)((Object)e)));
            }
        }
    }

    private static class TermResolverMock<T>
    implements TermResolver<T> {
        private String output;
        private Set<String> params;
        private T result;
        private Set<String> prereqs;
        private int cost;
        private boolean isExploder = false;

        public TermResolverMock(String output, T result, int cost, String ... prereqs) {
            this(output, null, result, cost, prereqs);
        }

        public TermResolverMock(String output, Set<String> params, T result, int cost, String ... prereqs) {
            this.output = output;
            this.params = Collections.unmodifiableSet(params);
            this.result = result;
            this.prereqs = new HashSet<String>(Arrays.asList(prereqs));
            this.cost = cost;
        }

        public int getCost() {
            return this.cost;
        }

        public String getOutput() {
            return this.output;
        }

        public Set<String> getPrerequisites() {
            return this.prereqs;
        }

        public Set<String> getParameterNames() {
            return this.params;
        }

        public void setIsExploder(boolean isExploder) {
            this.isExploder = isExploder;
        }

        public T resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) {
            if (this.isExploder) {
                throw new RuntimeException("I'm the exploder, coo coo catchoo");
            }
            for (String prereq : this.prereqs) {
                Object result = resolvedPrereqs.get(prereq);
                if (result != null) continue;
                Assert.fail((String)("got back null for prereq " + prereq));
            }
            LOG.info((Object)("resolving " + this.output));
            return this.result;
        }

        public String toString() {
            String paramStr = "";
            if (!CollectionUtils.isEmpty(this.params)) {
                paramStr = "+(" + StringUtils.join(this.params, (String)",") + ")";
            }
            return this.getClass().getSimpleName() + "[ " + this.output + paramStr + " <- " + StringUtils.join(this.prereqs.iterator(), (String)",") + " ]";
        }
    }

    private static class WhiteBoxTermResolutionEngineImpl
    extends TermResolutionEngineImpl {
        private WhiteBoxTermResolutionEngineImpl() {
        }

        public List<TermResolutionEngineImpl.TermResolverKey> buildTermResolutionPlan(String termName) {
            return super.buildTermResolutionPlan(termName);
        }
    }
}

