/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RuleBo;

public class AgendaItemBo
extends PersistableBusinessObjectBase {
    public static final String COPY_OF_TEXT = "Copy of ";
    private static final String KRMS_AGENDA_ITM_S = "KRMS_AGENDA_ITM_S";
    private String id;
    private String agendaId;
    private String ruleId;
    private String subAgendaId;
    private String whenTrueId;
    private String whenFalseId;
    private String alwaysId;
    private RuleBo rule;
    private AgendaItemBo whenTrue;
    private AgendaItemBo whenFalse;
    private AgendaItemBo always;
    private static SequenceAccessorService sequenceAccessorService;

    public String getUl(AgendaItemBo firstItem) {
        return "<ul>" + this.getUlHelper(firstItem) + "</ul>";
    }

    public String getUlHelper(AgendaItemBo item) {
        StringBuilder sb = new StringBuilder();
        sb.append("<li>" + this.ruleId + "</li>");
        if (this.whenTrue != null) {
            sb.append("<ul><li>when true</li><ul>");
            sb.append(this.getUlHelper(this.whenTrue));
            sb.append("</ul></ul>");
        }
        if (this.whenFalse != null) {
            sb.append("<ul><li>when false</li><ul>");
            sb.append(this.getUlHelper(this.whenFalse));
            sb.append("</ul></ul>");
        }
        if (this.always != null) {
            sb.append(this.getUlHelper(this.always));
        }
        return sb.toString();
    }

    public String getRuleText() {
        StringBuilder resultBuilder = new StringBuilder();
        if (this.getRule() != null) {
            if (StringUtils.isBlank((String)this.getRule().getName())) {
                resultBuilder.append("- unnamed rule -");
            } else {
                resultBuilder.append(this.getRule().getName());
            }
            if (!StringUtils.isBlank((String)this.getRule().getDescription())) {
                resultBuilder.append(": ");
                resultBuilder.append(this.getRule().getDescription());
            }
            if (!CollectionUtils.isEmpty(this.getRule().getActions())) {
                resultBuilder.append("   [");
                ActionBo action = this.getRule().getActions().get(0);
                KrmsTypeDefinition krmsTypeDefn = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService().getTypeById(action.getTypeId());
                resultBuilder.append(krmsTypeDefn.getName());
                resultBuilder.append(": ");
                resultBuilder.append(action.getName());
                if (this.getRule().getActions().size() > 1) {
                    resultBuilder.append(" ... ");
                }
                resultBuilder.append("]");
            }
        } else {
            throw new IllegalStateException();
        }
        return resultBuilder.toString();
    }

    public List<AgendaItemBo> getAlwaysList() {
        ArrayList<AgendaItemBo> results = new ArrayList<AgendaItemBo>();
        AgendaItemBo currentNode = this;
        while (currentNode.always != null) {
            results.add(currentNode.always);
            currentNode = currentNode.always;
        }
        return results;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAgendaId() {
        return this.agendaId;
    }

    public void setAgendaId(String agendaId) {
        this.agendaId = agendaId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getSubAgendaId() {
        return this.subAgendaId;
    }

    public void setSubAgendaId(String subAgendaId) {
        this.subAgendaId = subAgendaId;
    }

    public String getWhenTrueId() {
        return this.whenTrueId;
    }

    public void setWhenTrueId(String whenTrueId) {
        this.whenTrueId = whenTrueId;
    }

    public String getWhenFalseId() {
        return this.whenFalseId;
    }

    public void setWhenFalseId(String whenFalseId) {
        this.whenFalseId = whenFalseId;
    }

    public String getAlwaysId() {
        return this.alwaysId;
    }

    public void setAlwaysId(String alwaysId) {
        this.alwaysId = alwaysId;
    }

    public AgendaItemBo getWhenTrue() {
        return this.whenTrue;
    }

    public void setWhenTrue(AgendaItemBo whenTrue) {
        this.whenTrue = whenTrue;
        if (whenTrue != null) {
            this.setWhenTrueId(whenTrue.getId());
        } else {
            this.setWhenTrueId(null);
        }
    }

    public AgendaItemBo getWhenFalse() {
        return this.whenFalse;
    }

    public void setWhenFalse(AgendaItemBo whenFalse) {
        this.whenFalse = whenFalse;
        if (whenFalse != null) {
            this.setWhenFalseId(whenFalse.getId());
        } else {
            this.setWhenFalseId(null);
        }
    }

    public AgendaItemBo getAlways() {
        return this.always;
    }

    public void setAlways(AgendaItemBo always) {
        this.always = always;
        if (always != null) {
            this.setAlwaysId(always.getId());
        } else {
            this.setAlwaysId(null);
        }
    }

    public RuleBo getRule() {
        return this.rule;
    }

    public void setRule(RuleBo rule) {
        this.rule = rule;
        if (rule != null) {
            this.setRuleId(rule.getId());
        } else {
            this.setRuleId(null);
        }
    }

    static AgendaItemDefinition to(AgendaItemBo bo) {
        if (bo == null) {
            return null;
        }
        AgendaItemDefinition.Builder builder = AgendaItemDefinition.Builder.create((String)bo.getId(), (String)bo.getAgendaId());
        builder.setRuleId(bo.getRuleId());
        builder.setSubAgendaId(bo.getSubAgendaId());
        builder.setWhenTrueId(bo.getWhenTrueId());
        builder.setWhenFalseId(bo.getWhenFalseId());
        builder.setAlwaysId(bo.getAlwaysId());
        return builder.build();
    }

    static AgendaItemBo from(AgendaItemDefinition im) {
        if (im == null) {
            return null;
        }
        AgendaItemBo bo = new AgendaItemBo();
        bo.id = im.getId();
        bo.agendaId = im.getAgendaId();
        bo.ruleId = im.getRuleId();
        bo.subAgendaId = im.getSubAgendaId();
        bo.whenTrueId = im.getWhenTrueId();
        bo.whenFalseId = im.getWhenFalseId();
        bo.alwaysId = im.getAlwaysId();
        return bo;
    }

    public AgendaItemBo copyAgendaItem(AgendaBo copiedAgenda, Map<String, RuleBo> oldRuleIdToNew, Map<String, AgendaItemBo> oldAgendaItemIdToNew, List<AgendaItemBo> copiedAgendaItems, String dts) {
        AgendaItemBo copiedAgendaItem = (AgendaItemBo)((Object)ObjectUtils.deepCopy((Serializable)((Object)this)));
        copiedAgendaItem.setId(AgendaItemBo.getNewId());
        copiedAgendaItem.setAgendaId(copiedAgenda.getId());
        oldAgendaItemIdToNew.put(this.getId(), copiedAgendaItem);
        if (!oldRuleIdToNew.containsKey(this.getRuleId())) {
            if (this.getRule() != null) {
                copiedAgendaItem.setRule(this.getRule().copyRule(COPY_OF_TEXT + this.getRule().getName() + " " + dts));
                oldRuleIdToNew.put(this.getRuleId(), copiedAgendaItem.getRule());
            }
        } else {
            copiedAgendaItem.setRule(oldRuleIdToNew.get(this.getRuleId()));
        }
        if (copiedAgendaItem.getWhenFalse() != null) {
            if (!oldAgendaItemIdToNew.containsKey(this.getWhenFalseId())) {
                copiedAgendaItem.setWhenFalse(this.getWhenFalse().copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts));
                oldAgendaItemIdToNew.put(this.getWhenFalseId(), copiedAgendaItem.getWhenFalse());
                copiedAgendaItems.add(copiedAgendaItem.getWhenFalse());
            } else {
                copiedAgendaItem.setWhenFalse(oldAgendaItemIdToNew.get(this.getWhenFalseId()));
            }
        }
        if (copiedAgendaItem.getWhenTrue() != null) {
            if (!oldAgendaItemIdToNew.containsKey(this.getWhenTrueId())) {
                copiedAgendaItem.setWhenTrue(this.getWhenTrue().copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts));
                oldAgendaItemIdToNew.put(this.getWhenTrueId(), copiedAgendaItem.getWhenTrue());
                copiedAgendaItems.add(copiedAgendaItem.getWhenTrue());
            } else {
                copiedAgendaItem.setWhenTrue(oldAgendaItemIdToNew.get(this.getWhenTrueId()));
            }
        }
        if (copiedAgendaItem.getAlways() != null) {
            if (!oldAgendaItemIdToNew.containsKey(this.getAlwaysId())) {
                copiedAgendaItem.setAlways(this.getAlways().copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts));
                oldAgendaItemIdToNew.put(this.getAlwaysId(), copiedAgendaItem.getAlways());
                copiedAgendaItems.add(copiedAgendaItem.getAlways());
            } else {
                copiedAgendaItem.setAlways(oldAgendaItemIdToNew.get(this.getAlwaysId()));
            }
        }
        return copiedAgendaItem;
    }

    public static void setSequenceAccessorService(SequenceAccessorService sas) {
        sequenceAccessorService = sas;
    }

    private static String getNewId() {
        if (sequenceAccessorService == null) {
            return KRADServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber(KRMS_AGENDA_ITM_S, AgendaItemBo.class) + "";
        }
        Long id = sequenceAccessorService.getNextAvailableSequenceNumber(KRMS_AGENDA_ITM_S, AgendaItemBo.class);
        return id.toString();
    }
}

