/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterContract;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionBoService;
import org.kuali.rice.krms.impl.repository.PropositionParameterBo;

public final class PropositionBoServiceImpl
implements PropositionBoService {
    private BusinessObjectService businessObjectService;

    @Override
    public PropositionDefinition createProposition(PropositionDefinition prop) {
        if (prop == null) {
            throw new IllegalArgumentException("proposition is null");
        }
        if (null != prop.getId()) {
            throw new IllegalStateException("for creation, PropositionDefinition.id must be null");
        }
        PropositionBo propositionBo = PropositionBo.from(prop);
        this.businessObjectService.save((PersistableBusinessObject)propositionBo);
        return PropositionBo.to(propositionBo);
    }

    @Override
    public void updateProposition(PropositionDefinition prop) {
        PropositionDefinition toUpdate;
        if (prop == null) {
            throw new IllegalArgumentException("proposition is null");
        }
        String propIdKey = prop.getId();
        PropositionDefinition existing = this.getPropositionById(propIdKey);
        if (existing == null) {
            throw new IllegalStateException("the proposition does not exist: " + prop);
        }
        if (!existing.getId().equals(prop.getId())) {
            PropositionDefinition.Builder builder = PropositionDefinition.Builder.create((PropositionDefinitionContract)prop);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = prop;
        }
        this.businessObjectService.save((PersistableBusinessObject)PropositionBo.from(toUpdate));
    }

    @Override
    public PropositionDefinition getPropositionById(String propId) {
        if (StringUtils.isBlank((String)propId)) {
            throw new IllegalArgumentException("propId is null or blank");
        }
        PropositionBo bo = (PropositionBo)this.businessObjectService.findBySinglePrimaryKey(PropositionBo.class, (Object)propId);
        return PropositionBo.to(bo);
    }

    @Override
    public void createParameter(PropositionParameter parameter) {
        Integer seqNoKey;
        if (parameter == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        String propIdKey = parameter.getPropId();
        PropositionParameter existing = this.getParameterByPropIdAndSequenceNumber(propIdKey, seqNoKey = parameter.getSequenceNumber());
        if (existing != null && existing.getPropId().equals(propIdKey) && existing.getSequenceNumber().equals(seqNoKey)) {
            throw new IllegalStateException("the parameter to create already exists: " + parameter);
        }
        this.businessObjectService.save((PersistableBusinessObject)PropositionParameterBo.from(parameter));
    }

    @Override
    public void updateParameter(PropositionParameter parameter) {
        PropositionParameter toUpdate;
        Integer seqNoKey;
        if (parameter == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        String propIdKey = parameter.getPropId();
        PropositionParameter existing = this.getParameterByPropIdAndSequenceNumber(propIdKey, seqNoKey = parameter.getSequenceNumber());
        if (existing == null) {
            throw new IllegalStateException("the parameter does not exist: " + parameter);
        }
        if (!existing.getId().equals(parameter.getId())) {
            PropositionParameter.Builder builder = PropositionParameter.Builder.create((PropositionParameterContract)parameter);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = parameter;
        }
        this.businessObjectService.save((PersistableBusinessObject)PropositionParameterBo.from(toUpdate));
    }

    @Override
    public List<PropositionParameter> getParameters(String propId) {
        if (StringUtils.isBlank((String)propId)) {
            throw new IllegalArgumentException("propId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("propId", propId);
        List bos = (List)this.businessObjectService.findMatchingOrderBy(PropositionParameterBo.class, map, "sequenceNumber", true);
        return PropositionParameterBo.to(bos);
    }

    @Override
    public PropositionParameter getParameterById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is null or blank");
        }
        PropositionParameterBo bo = (PropositionParameterBo)this.businessObjectService.findBySinglePrimaryKey(PropositionParameterBo.class, (Object)id);
        return PropositionParameterBo.to(bo);
    }

    @Override
    public PropositionParameter getParameterByPropIdAndSequenceNumber(String propId, Integer sequenceNumber) {
        if (StringUtils.isBlank((String)propId)) {
            throw new IllegalArgumentException("propId is null or blank");
        }
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("sequenceNumber is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propId", propId);
        map.put("sequenceNumber", sequenceNumber);
        PropositionParameterBo bo = (PropositionParameterBo)this.businessObjectService.findByPrimaryKey(PropositionParameterBo.class, map);
        return PropositionParameterBo.to(bo);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

