/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.impl.repository.RuleAttributeBo;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoService;

public final class RuleBoServiceImpl
implements RuleBoService {
    private BusinessObjectService businessObjectService;

    @Override
    public RuleDefinition createRule(RuleDefinition rule) {
        String namespaceKey;
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        String nameKey = rule.getName();
        RuleDefinition existing = this.getRuleByNameAndNamespace(nameKey, namespaceKey = rule.getNamespace());
        if (existing != null) {
            throw new IllegalStateException("the rule to create already exists: " + rule);
        }
        RuleBo ruleBo = RuleBo.from(rule);
        this.businessObjectService.save((PersistableBusinessObject)ruleBo);
        return RuleBo.to(ruleBo);
    }

    @Override
    public void updateRule(RuleDefinition rule) {
        RuleDefinition toUpdate;
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        String ruleIdKey = rule.getId();
        RuleBo existing = (RuleBo)this.businessObjectService.findBySinglePrimaryKey(RuleBo.class, (Object)ruleIdKey);
        if (existing == null) {
            throw new IllegalStateException("the rule does not exist: " + rule);
        }
        if (!existing.getId().equals(rule.getId())) {
            RuleDefinition.Builder builder = RuleDefinition.Builder.create((RuleDefinitionContract)rule);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = rule;
        }
        RuleBo boToUpdate = RuleBo.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("ruleId", toUpdate.getId());
        this.businessObjectService.deleteMatching(RuleAttributeBo.class, fields);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    @Override
    public RuleDefinition getRuleByRuleId(String ruleId) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("rule id is null");
        }
        RuleBo bo = (RuleBo)this.businessObjectService.findBySinglePrimaryKey(RuleBo.class, (Object)ruleId);
        return RuleBo.to(bo);
    }

    @Override
    public RuleDefinition getRuleByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        RuleBo myRule = (RuleBo)this.businessObjectService.findByPrimaryKey(RuleBo.class, Collections.unmodifiableMap(map));
        return RuleBo.to(myRule);
    }

    public RuleAttributeBo getRuleAttributeById(String attrId) {
        if (StringUtils.isBlank((String)attrId)) {
            return null;
        }
        RuleAttributeBo bo = (RuleAttributeBo)this.businessObjectService.findBySinglePrimaryKey(RuleAttributeBo.class, (Object)attrId);
        return bo;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public List<RuleDefinition> convertListOfBosToImmutables(Collection<RuleBo> ruleBos) {
        ArrayList<RuleDefinition> rules = new ArrayList<RuleDefinition>();
        for (RuleBo bo : ruleBos) {
            RuleDefinition rule = RuleBo.to(bo);
            rules.add(rule);
        }
        return Collections.unmodifiableList(rules);
    }
}

