/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermResolverBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;
import org.springframework.util.CollectionUtils;

public class TermBoServiceImpl
implements TermBoService,
TermRepositoryService {
    private BusinessObjectService businessObjectService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public TermSpecificationDefinition getTermSpecificationById(String id) {
        TermSpecificationBo termSpecificationBo = (TermSpecificationBo)this.businessObjectService.findBySinglePrimaryKey(TermSpecificationBo.class, (Object)id);
        return TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpecificationBo).build();
    }

    @Override
    public TermSpecificationDefinition createTermSpecification(TermSpecificationDefinition termSpec) {
        if (!StringUtils.isBlank((String)termSpec.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermSpecification.id must be null");
        }
        TermSpecificationBo termSpecBo = TermSpecificationBo.from(termSpec);
        this.businessObjectService.save((PersistableBusinessObject)termSpecBo);
        return TermSpecificationBo.to(termSpecBo);
    }

    @Override
    public TermDefinition createTerm(TermDefinition termDef) {
        if (!StringUtils.isBlank((String)termDef.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermDefinition.id must be null");
        }
        TermBo termBo = TermBo.from(termDef);
        this.businessObjectService.save((PersistableBusinessObject)termBo);
        return TermBo.to(termBo);
    }

    @Override
    public TermResolverDefinition createTermResolver(TermResolverDefinition termResolver) {
        if (!StringUtils.isBlank((String)termResolver.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermResolverDefinition.id must be null");
        }
        TermResolverBo termResolverBo = TermResolverBo.from(termResolver);
        termResolverBo = (TermResolverBo)this.businessObjectService.save((PersistableBusinessObject)termResolverBo);
        return TermResolverBo.to(termResolverBo);
    }

    @Override
    public TermDefinition getTerm(String id) {
        TermDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermBo termBo = (TermBo)this.businessObjectService.findBySinglePrimaryKey(TermBo.class, (Object)id);
        if (termBo != null) {
            result = TermBo.to(termBo);
        }
        return result;
    }

    @Override
    public TermResolverDefinition getTermResolverById(String id) {
        TermResolverDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermResolverBo termResolverBo = (TermResolverBo)this.businessObjectService.findBySinglePrimaryKey(TermResolverBo.class, (Object)id);
        if (termResolverBo != null) {
            result = TermResolverBo.to(termResolverBo);
        }
        return result;
    }

    @Override
    public List<TermResolverDefinition> findTermResolversByOutputId(String id, String namespace) {
        List<TermResolverDefinition> results = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace must not be blank or null");
        }
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("outputId", id);
        criteria.put("namespace", namespace);
        Collection termResolverBos = this.businessObjectService.findMatching(TermResolverBo.class, criteria);
        if (!CollectionUtils.isEmpty((Collection)termResolverBos)) {
            results = new ArrayList<TermResolverDefinition>(termResolverBos.size());
            for (TermResolverBo termResolverBo : termResolverBos) {
                results.add(TermResolverBo.to(termResolverBo));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<TermResolverDefinition> findTermResolversByNamespace(String namespace) {
        List<TermResolverDefinition> results = null;
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace must not be blank or null");
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("namespace", namespace);
        Collection termResolverBos = this.businessObjectService.findMatching(TermResolverBo.class, fieldValues);
        if (!CollectionUtils.isEmpty((Collection)termResolverBos)) {
            results = new ArrayList<TermResolverDefinition>(termResolverBos.size());
            for (TermResolverBo termResolverBo : termResolverBos) {
                if (termResolverBo == null) continue;
                results.add(TermResolverBo.to(termResolverBo));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public List<TermSpecificationDefinition> findAllTermSpecificationsByContextId(String contextId) {
        List<TermSpecificationDefinition> results = null;
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId must not be blank or null");
        }
        Collection contextValidTerms = this.businessObjectService.findMatching(ContextValidTermBo.class, Collections.singletonMap("contextId", contextId));
        if (!CollectionUtils.isEmpty((Collection)contextValidTerms)) {
            results = new ArrayList<TermSpecificationDefinition>(contextValidTerms.size());
            for (ContextValidTermBo validTerm : contextValidTerms) {
                results.add(TermSpecificationBo.to(validTerm.getTermSpecification()));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }
}

