/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.type;

import java.util.HashMap;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgenda;
import org.kuali.rice.krms.framework.type.AgendaTypeService;
import org.kuali.rice.krms.impl.provider.repository.LazyAgendaTree;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.type.KrmsTypeServiceBase;
import org.kuali.rice.krms.impl.util.KRMSServiceLocatorInternal;

public class AgendaTypeServiceBase
extends KrmsTypeServiceBase
implements AgendaTypeService {
    public static final AgendaTypeService defaultAgendaTypeService = new AgendaTypeServiceBase();
    private static final String NAME_ATTRIBUTE = "name";

    public Agenda loadAgenda(AgendaDefinition agendaDefinition) {
        if (agendaDefinition == null) {
            throw new RiceIllegalArgumentException("agendaDefinition must not be null");
        }
        if (this.getRepositoryToEngineTranslator() == null) {
            return null;
        }
        HashMap<String, String> existingAttributes = new HashMap<String, String>(agendaDefinition.getAttributes());
        existingAttributes.put(NAME_ATTRIBUTE, agendaDefinition.getName());
        return new BasicAgenda(existingAttributes, (AgendaTree)new LazyAgendaTree(agendaDefinition, this.getRepositoryToEngineTranslator()));
    }

    private RepositoryToEngineTranslator getRepositoryToEngineTranslator() {
        return RepositoryToEngineTranslatorHolder.instance;
    }

    private static class RepositoryToEngineTranslatorHolder {
        static final RepositoryToEngineTranslator instance = KRMSServiceLocatorInternal.getRepositoryToEngineTranslator();

        private RepositoryToEngineTranslatorHolder() {
        }
    }
}

