/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceForm;
import org.kuali.rice.krms.impl.repository.CategoryBo;
import org.kuali.rice.krms.impl.ui.AgendaEditor;

public class CategoryValuesFinder
extends UifKeyValuesFinderBase {
    private boolean blankOption;

    public boolean isBlankOption() {
        return this.blankOption;
    }

    public void setBlankOption(boolean blankOption) {
        this.blankOption = blankOption;
    }

    public List<KeyValue> getKeyValues(ViewModel model) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        MaintenanceForm maintenanceForm = (MaintenanceForm)model;
        AgendaEditor agendaEditor = (AgendaEditor)((Object)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject());
        if (agendaEditor.getAgenda() != null && StringUtils.isNotBlank((String)agendaEditor.getAgenda().getContextId())) {
            String namespace = agendaEditor.getNamespace();
            if (this.blankOption) {
                keyValues.add((KeyValue)new ConcreteKeyValue("", ""));
            }
            Map<String, String> criteria = Collections.singletonMap("namespace", namespace);
            Collection categories = KRADServiceLocator.getBusinessObjectService().findMatchingOrderBy(CategoryBo.class, criteria, "name", true);
            for (CategoryBo category : categories) {
                keyValues.add((KeyValue)new ConcreteKeyValue(category.getId(), category.getName()));
            }
        }
        return keyValues;
    }
}

