/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.Map;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.impl.cache.DistributedCacheManagerDecorator;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krms.impl.repository.ContextBo;

public class ContextMaintainable
extends MaintainableImpl {
    private transient SequenceAccessorService sequenceAccessorService;

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        ContextBo newContext = (ContextBo)((Object)document.getNewMaintainableObject().getDataObject());
        String nextId = this.getSequenceAccessorService().getNextAvailableSequenceNumber("KRMS_CNTXT_S", ContextBo.class).toString();
        newContext.setId(nextId);
        super.processAfterNew(document, requestParameters);
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        ContextBo context = (ContextBo)((Object)document.getNewMaintainableObject().getDataObject());
        String nextId = this.getSequenceAccessorService().getNextAvailableSequenceNumber("KRMS_CNTXT_S", ContextBo.class).toString();
        context.setId(nextId);
        super.processAfterCopy(document, requestParameters);
    }

    public void saveDataObject() {
        super.saveDataObject();
        DistributedCacheManagerDecorator distributedCacheManagerDecorator = (DistributedCacheManagerDecorator)GlobalResourceLoader.getService((String)"krmsDistributedCacheManager");
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/ContextDefinitionType").clear();
    }

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        ContextBo contextBo = (ContextBo)((Object)super.retrieveObjectForEditOrCopy(document, dataObjectKeys));
        if ("Copy".equals(this.getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Context Document");
            contextBo = contextBo.copyContext(" Copy " + System.currentTimeMillis());
        }
        return contextBo;
    }

    private SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KRADServiceLocator.getSequenceAccessorService();
        }
        return this.sequenceAccessorService;
    }
}

