/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.List;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionParameterBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.ui.RuleTreeNode;

public class SimplePropositionEditNode
extends RuleTreeNode {
    private static final long serialVersionUID = -5650654824214437325L;
    public static final String NODE_TYPE = "ruleTreeNode simplePropositionEditNode";
    protected String parameterDisplayString;

    public SimplePropositionEditNode(PropositionBo proposition) {
        super(proposition);
        this.setupParameterDisplayString();
    }

    private void setupParameterDisplayString() {
        List<PropositionParameterBo> parameters;
        if (this.proposition != null && this.proposition.getPropositionTypeCode().equalsIgnoreCase(PropositionType.SIMPLE.getCode()) && (parameters = this.proposition.getParameters()) != null && parameters.size() == 3) {
            this.setParameterDisplayString(this.getParamValue(parameters.get(0)) + " " + this.getParamValue(parameters.get(2)) + " " + this.getParamValue(parameters.get(1)));
        }
    }

    private String getParamValue(PropositionParameterBo prop) {
        if (PropositionParameterType.TERM.getCode().equalsIgnoreCase(prop.getParameterType())) {
            TermBo term;
            String termName = "";
            String termId = prop.getValue();
            if (termId != null && termId.length() > 0 && (term = (TermBo)this.getBoService().findBySinglePrimaryKey(TermBo.class, (Object)termId)) != null) {
                termName = term.getSpecification().getName();
            }
            return termName;
        }
        return prop.getValue();
    }

    public String getParameterDisplayString() {
        return this.parameterDisplayString;
    }

    public void setParameterDisplayString(String parameterDisplayString) {
        this.parameterDisplayString = parameterDisplayString;
    }

    public BusinessObjectService getBoService() {
        return KRADServiceLocator.getBusinessObjectService();
    }
}

