/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.MaintenanceForm;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermResolverBo;
import org.kuali.rice.krms.impl.repository.TermResolverParameterSpecificationBo;

public class TermMaintainable
extends MaintainableImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(TermMaintainable.class);

    public BusinessObjectService getBoService() {
        return KRADServiceLocator.getBusinessObjectService();
    }

    public List<RemotableAttributeField> retrieveCustomAttributes(View view, Object model, Container container) {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        String termSpecId = ((TermBo)((Object)((MaintenanceForm)model).getDocument().getNewMaintainableObject().getDataObject())).getSpecificationId();
        Collection termResolvers = this.getBoService().findMatching(TermResolverBo.class, Collections.singletonMap("outputId", termSpecId));
        TermResolverBo termResolver = null;
        if (termResolvers != null && termResolvers.size() == 1) {
            termResolver = (TermResolverBo)((Object)termResolvers.iterator().next());
        }
        if (termResolver != null && !CollectionUtils.isEmpty(termResolver.getParameterSpecifications())) {
            ArrayList<TermResolverParameterSpecificationBo> params = new ArrayList<TermResolverParameterSpecificationBo>(termResolver.getParameterSpecifications());
            Collections.sort(params, new Comparator<TermResolverParameterSpecificationBo>(){

                @Override
                public int compare(TermResolverParameterSpecificationBo o1, TermResolverParameterSpecificationBo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (TermResolverParameterSpecificationBo param : params) {
                RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)param.getName());
                RemotableTextInput.Builder inputBuilder = RemotableTextInput.Builder.create();
                inputBuilder.setSize(Integer.valueOf(80));
                builder.setControl((RemotableAbstractControl.Builder)inputBuilder);
                builder.setDataType(DataType.STRING);
                builder.setLongLabel(param.getName());
                builder.setShortLabel(param.getName());
                results.add(builder.build());
            }
        }
        return results;
    }

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        TermBo termBo = (TermBo)((Object)super.retrieveObjectForEditOrCopy(document, dataObjectKeys));
        termBo.exportToParametersMap();
        if ("Copy".equals(this.getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Term Document");
        }
        return termBo;
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterNew(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("New Term Document");
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterEdit(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("Edited Term Document");
    }

    public void saveDataObject() {
        TermBo term = (TermBo)((Object)this.getDataObject());
        term.importFromParametersMap();
        super.saveDataObject();
    }

    public Class getDataObjectClass() {
        return TermBo.class;
    }

    protected void processBeforeAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
        super.processBeforeAddLine(view, collectionGroup, model, addLine);
    }
}

