/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;

public class TermSpecificationMaintainable
extends MaintainableImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(TermSpecificationMaintainable.class);

    public BusinessObjectService getBoService() {
        return KRADServiceLocator.getBusinessObjectService();
    }

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        TermSpecificationBo termSpecificationBo = (TermSpecificationBo)((Object)super.retrieveObjectForEditOrCopy(document, dataObjectKeys));
        if ("Copy".equals(this.getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Term Specification Document");
        }
        return termSpecificationBo;
    }

    private void findContexts(TermSpecificationBo termSpecificationBo) {
        Collection validContextMappings = this.getBoService().findMatching(ContextValidTermBo.class, Collections.singletonMap("termSpecificationId", termSpecificationBo.getId()));
        if (!CollectionUtils.isEmpty((Collection)validContextMappings)) {
            for (ContextValidTermBo validContextMapping : validContextMappings) {
                ContextBo context = (ContextBo)this.getBoService().findBySinglePrimaryKey(ContextBo.class, (Object)validContextMapping.getContextId());
                termSpecificationBo.getContexts().add(context);
            }
        }
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterNew(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("New Term Specification Document");
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterEdit(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("Edited Term Specification Document");
    }

    public void saveDataObject() {
        TermSpecificationBo termSpec = (TermSpecificationBo)((Object)this.getDataObject());
        super.saveDataObject();
        if (termSpec.getId() != null) {
            this.getBoService().deleteMatching(ContextValidTermBo.class, Collections.singletonMap("termSpecificationId", termSpec.getId()));
            if (!CollectionUtils.isEmpty(termSpec.getContexts())) {
                for (ContextBo context : termSpec.getContexts()) {
                    ContextValidTermBo contextValidTerm = new ContextValidTermBo();
                    contextValidTerm.setContextId(context.getId());
                    contextValidTerm.setTermSpecificationId(termSpec.getId());
                    this.getBoService().save((PersistableBusinessObject)contextValidTerm);
                }
            }
        }
    }

    public Class getDataObjectClass() {
        return TermSpecificationBo.class;
    }

    protected void processBeforeAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
        super.processBeforeAddLine(view, collectionGroup, model, addLine);
    }
}

