/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.KrmsTypeGenTest;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.mockito.Mockito;

public final class KrmsTypeBoServiceImplGenTest {
    KrmsTypeBoServiceImpl krmsTypeBoServiceImpl;
    KrmsTypeDefinition krmsType;

    KrmsTypeDefinition getKrmsType() {
        return this.krmsType;
    }

    KrmsTypeDefinition getKrmsTypeDefinition() {
        return this.getKrmsType();
    }

    public void setKrmsTypeBoServiceImpl(KrmsTypeBoServiceImpl impl) {
        this.krmsTypeBoServiceImpl = impl;
    }

    public static KrmsTypeBoServiceImplGenTest create(KrmsTypeBoServiceImpl impl) {
        KrmsTypeBoServiceImplGenTest test = new KrmsTypeBoServiceImplGenTest();
        test.setKrmsTypeBoServiceImpl(impl);
        return test;
    }

    @Before
    public void setUp() {
        this.krmsTypeBoServiceImpl = new KrmsTypeBoServiceImpl();
        KrmsAttributeDefinitionService mockAttributeService = (KrmsAttributeDefinitionService)Mockito.mock(KrmsAttributeDefinitionService.class);
        this.krmsTypeBoServiceImpl.setBusinessObjectService((BusinessObjectService)Mockito.mock(BusinessObjectService.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getTypeById_null_fail() {
        this.krmsTypeBoServiceImpl.getTypeById(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getTypeByName_null_fail() {
        this.krmsTypeBoServiceImpl.getTypeByName(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllTypesByNamespace_null_fail() {
        this.krmsTypeBoServiceImpl.findAllTypesByNamespace(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllAgendaTypesByContextId_null_fail() {
        this.krmsTypeBoServiceImpl.findAllAgendaTypesByContextId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAgendaTypeByAgendaTypeIdAndContextId_null_fail() {
        this.krmsTypeBoServiceImpl.getAgendaTypeByAgendaTypeIdAndContextId(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllRuleTypesByContextId_null_fail() {
        this.krmsTypeBoServiceImpl.findAllRuleTypesByContextId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getRuleTypeByRuleTypeIdAndContextId_null_fail() {
        this.krmsTypeBoServiceImpl.getRuleTypeByRuleTypeIdAndContextId(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllActionTypesByContextId_null_fail() {
        this.krmsTypeBoServiceImpl.findAllActionTypesByContextId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getActionTypeByActionTypeIdAndContextId_null_fail() {
        this.krmsTypeBoServiceImpl.getActionTypeByActionTypeIdAndContextId(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAttributeDefinitionById_null_fail() {
        this.krmsTypeBoServiceImpl.getAttributeDefinitionById(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAttributeDefinitionByName_null_fail() {
        this.krmsTypeBoServiceImpl.getAttributeDefinitionByName(null, null);
    }

    @Test
    public void test_createKrmsType() {
        KrmsTypeDefinition def = KrmsTypeGenTest.buildFullKrmsTypeDefinition();
        this.krmsType = this.krmsTypeBoServiceImpl.getTypeByName(def.getNamespace(), def.getName());
        if (this.krmsType == null) {
            this.krmsType = this.krmsTypeBoServiceImpl.createKrmsType(def);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createKrmsType_null_fail() {
        this.krmsTypeBoServiceImpl.createKrmsType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateKrmsType_null_fail() {
        this.krmsTypeBoServiceImpl.updateKrmsType(null);
    }
}

