/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.TypeTypeRelationGenTest;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBo;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoServiceImpl;
import org.mockito.Mockito;

public final class TypeTypeRelationBoServiceImplGenTest {
    TypeTypeRelationBoServiceImpl typeTypeRelationBoServiceImpl;
    TypeTypeRelation typeTypeRelation;

    TypeTypeRelation getTypeTypeRelation() {
        return this.typeTypeRelation;
    }

    public void setTypeTypeRelationBoServiceImpl(TypeTypeRelationBoServiceImpl impl) {
        this.typeTypeRelationBoServiceImpl = impl;
    }

    public static TypeTypeRelationBoServiceImplGenTest create(TypeTypeRelationBoServiceImpl impl) {
        TypeTypeRelationBoServiceImplGenTest test = new TypeTypeRelationBoServiceImplGenTest();
        test.setTypeTypeRelationBoServiceImpl(impl);
        return test;
    }

    @Before
    public void setUp() {
        this.typeTypeRelationBoServiceImpl = new TypeTypeRelationBoServiceImpl();
        this.typeTypeRelationBoServiceImpl.setBusinessObjectService((BusinessObjectService)Mockito.mock(BusinessObjectService.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByFromType_null_fail() {
        this.typeTypeRelationBoServiceImpl.findTypeTypeRelationsByFromType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByToType_null_fail() {
        this.typeTypeRelationBoServiceImpl.findTypeTypeRelationsByToType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByRelationshipType_null_fail() {
        this.typeTypeRelationBoServiceImpl.findTypeTypeRelationsByRelationshipType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsBySequenceNumber_null_fail() {
        this.typeTypeRelationBoServiceImpl.findTypeTypeRelationsBySequenceNumber(null);
    }

    @Test
    public void test_from_null_yields_null() {
        assert (this.typeTypeRelationBoServiceImpl.from(null) == null);
    }

    @Test
    public void test_from() {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        TypeTypeRelationBo typeTypeRelationBo = this.typeTypeRelationBoServiceImpl.from(def);
        assert (typeTypeRelationBo.getFromTypeId().equals(def.getFromTypeId()));
        assert (typeTypeRelationBo.getToTypeId().equals(def.getToTypeId()));
        assert (typeTypeRelationBo.getId().equals(def.getId()));
    }

    @Test
    public void test_to() {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        TypeTypeRelationBo typeTypeRelationBo = this.typeTypeRelationBoServiceImpl.from(def);
        TypeTypeRelation def2 = TypeTypeRelationBo.to((TypeTypeRelationBo)typeTypeRelationBo);
        assert (def.equals((Object)def2));
    }

    @Test
    public void test_createTypeTypeRelation() {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        this.typeTypeRelation = this.typeTypeRelationBoServiceImpl.createTypeTypeRelation(def);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createTypeTypeRelation_null_fail() {
        this.typeTypeRelationBoServiceImpl.createTypeTypeRelation(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateTypeTypeRelation_null_fail() {
        this.typeTypeRelationBoServiceImpl.updateTypeTypeRelation(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteTypeTypeRelation_null_fail() {
        this.typeTypeRelationBoServiceImpl.deleteTypeTypeRelation(null);
    }

    void createTypeTypeRelation(KrmsTypeDefinition fromType, KrmsTypeDefinition toType) {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullFKTypeTypeRelation((KrmsTypeDefinition)fromType, (KrmsTypeDefinition)toType);
        this.typeTypeRelation = this.typeTypeRelationBoServiceImpl.createTypeTypeRelation(def);
    }
}

