/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.TypeTypeRelationGenTest;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBo;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoServiceImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TypeTypeRelationBoServiceImplGenTest {
    private TypeTypeRelationBoServiceImpl service;
    private TypeTypeRelation typeTypeRelation;
    private DataObjectService mockDataObjectService = (DataObjectService)Mockito.mock(DataObjectService.class);

    @Before
    public void setUp() {
        this.service = new TypeTypeRelationBoServiceImpl();
        this.service.setDataObjectService(this.mockDataObjectService);
    }

    @Test
    public void test_createTypeTypeRelation_success() {
        Object findResult = null;
        TypeTypeRelationBo saveResult = this.service.from(TypeTypeRelationGenTest.buildFullTypeTypeRelation());
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn(findResult);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(TypeTypeRelationBo.class), new PersistenceOption[]{(PersistenceOption)Matchers.eq((Object)PersistenceOption.FLUSH)})).thenReturn((Object)saveResult);
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        TypeTypeRelation typeTypeRelation = this.service.createTypeTypeRelation(def);
        Assert.assertNotNull((Object)typeTypeRelation);
    }

    @Test(expected=IllegalStateException.class)
    public void test_createTypeTypeRelation_find_failure() {
        TypeTypeRelationBo findResult = this.service.from(TypeTypeRelationGenTest.buildFullTypeTypeRelation());
        TypeTypeRelationBo saveResult = this.service.from(TypeTypeRelationGenTest.buildFullTypeTypeRelation());
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)findResult);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(TypeTypeRelationBo.class), new PersistenceOption[]{(PersistenceOption)Matchers.eq((Object)PersistenceOption.FLUSH)})).thenReturn((Object)saveResult);
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        TypeTypeRelation typeTypeRelation = this.service.createTypeTypeRelation(def);
        Assert.assertNotNull((Object)typeTypeRelation);
    }

    @Test
    public void test_updateTypeTypeRelation_success() {
        TypeTypeRelationBo data1 = this.service.from(TypeTypeRelationGenTest.buildFullTypeTypeRelation());
        TypeTypeRelationBo data2 = this.service.from(TypeTypeRelationGenTest.buildFullTypeTypeRelation());
        TypeTypeRelation data3 = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)data1);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(TypeTypeRelationBo.class), new PersistenceOption[]{(PersistenceOption)Matchers.eq((Object)PersistenceOption.FLUSH)})).thenReturn((Object)data2);
        TypeTypeRelation updatedData = this.service.updateTypeTypeRelation(data3);
        Assert.assertNotNull((Object)updatedData);
    }

    @Test
    public void test_from_null_yields_null() {
        Assert.assertNull((Object)this.service.from(null));
    }

    @Test
    public void test_from() {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        TypeTypeRelationBo typeTypeRelationBo = this.service.from(def);
        Assert.assertEquals((Object)typeTypeRelationBo.getFromTypeId(), (Object)def.getFromTypeId());
        Assert.assertEquals((Object)typeTypeRelationBo.getToTypeId(), (Object)def.getToTypeId());
        Assert.assertEquals((Object)typeTypeRelationBo.getId(), (Object)def.getId());
    }

    @Test
    public void test_to() {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        TypeTypeRelationBo typeTypeRelationBo = this.service.from(def);
        TypeTypeRelation def2 = TypeTypeRelationBo.to((TypeTypeRelationBo)typeTypeRelationBo);
        Assert.assertEquals((Object)def, (Object)def2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByFromType_null_fail() {
        this.service.findTypeTypeRelationsByFromType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByToType_null_fail() {
        this.service.findTypeTypeRelationsByToType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByRelationshipType_null_fail() {
        this.service.findTypeTypeRelationsByRelationshipType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsBySequenceNumber_null_fail() {
        this.service.findTypeTypeRelationsBySequenceNumber(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createTypeTypeRelation_null_fail() {
        this.service.createTypeTypeRelation(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateTypeTypeRelation_null_fail() {
        this.service.updateTypeTypeRelation(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteTypeTypeRelation_null_fail() {
        this.service.deleteTypeTypeRelation(null);
    }

    public TypeTypeRelation createTypeTypeRelation(KrmsTypeDefinition fromType, KrmsTypeDefinition toType) {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullFKTypeTypeRelation((KrmsTypeDefinition)fromType, (KrmsTypeDefinition)toType);
        this.typeTypeRelation = this.service.createTypeTypeRelation(def);
        return this.typeTypeRelation;
    }

    public TypeTypeRelation createTypeTypeRelationGeneratedId(KrmsTypeDefinition fromType, KrmsTypeDefinition toType) {
        TypeTypeRelation def = TypeTypeRelationGenTest.buildFullFKTypeTypeRelationNoId((KrmsTypeDefinition)fromType, (KrmsTypeDefinition)toType);
        this.typeTypeRelation = this.service.createTypeTypeRelation(def);
        return this.typeTypeRelation;
    }

    public TypeTypeRelation getTypeTypeRelation() {
        return this.typeTypeRelation;
    }

    public void setTypeTypeRelationBoServiceImpl(TypeTypeRelationBoServiceImpl impl) {
        this.service = impl;
    }

    public static TypeTypeRelationBoServiceImplGenTest create(TypeTypeRelationBoServiceImpl impl) {
        TypeTypeRelationBoServiceImplGenTest test = new TypeTypeRelationBoServiceImplGenTest();
        test.setTypeTypeRelationBoServiceImpl(impl);
        return test;
    }
}

