/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.impl.repository.mock.CriteriaMatcherInMemory;

public class CriteriaMatcherInMemoryTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private List<ContextDefinition> getTestContexts() {
        ArrayList<ContextDefinition> contexts = new ArrayList<ContextDefinition>();
        this.addContext(contexts, "ID-AA", "AA", "Automobile Association", "Consumer", "true", "Automobile Association towing");
        this.addContext(contexts, "ID-CR", "CR", "Consumer Reports", "Consumer", "true", "Consumer reports magazine");
        this.addContext(contexts, "ID-ARP", "ARP", "Assciation of Retired Persons", "Consumer", "false", null);
        this.addContext(contexts, "ID-NRA", "NRA", "National Rifle Association", "Lobby", "true", "Guns and roses");
        this.addContext(contexts, "ID-UFT", "UFT", "United Federation of Teachers", "Lobby", "true", "tenure for everyone");
        this.addContext(contexts, "ID-AFL", "AFL", "AFL-CIO", "Union", "true", "Jimmy Hoffa may he rest in peace somewhere");
        return contexts;
    }

    private void addContext(List<ContextDefinition> contexts, String id, String namespace, String name, String typeId, String active, String description) {
        ContextDefinition.Builder info = ContextDefinition.Builder.create((String)namespace, (String)name);
        info.setId(id);
        info.setTypeId(typeId);
        info.setActive(Boolean.parseBoolean(active));
        info.setDescription(description);
        contexts.add(info.build());
    }

    @Test
    public void testFindAll1() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria criteria = null;
        instance.setCriteria(criteria);
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-AA");
        expectedIds.add("ID-CR");
        expectedIds.add("ID-ARP");
        expectedIds.add("ID-NRA");
        expectedIds.add("ID-UFT");
        expectedIds.add("ID-AFL");
        this.testIds(expectedIds, result);
    }

    @Test
    public void testFindAll2() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        instance.setCriteria(criteria.build());
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-AA");
        expectedIds.add("ID-CR");
        expectedIds.add("ID-ARP");
        expectedIds.add("ID-NRA");
        expectedIds.add("ID-UFT");
        expectedIds.add("ID-AFL");
        this.testIds(expectedIds, result);
    }

    @Test
    public void testFindEquals1() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"typeId", (Object)"Consumer")});
        instance.setCriteria(criteria.build());
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-AA");
        expectedIds.add("ID-CR");
        expectedIds.add("ID-ARP");
        this.testIds(expectedIds, result);
    }

    @Test
    public void testFindEquals2() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"active", (Object)"true")});
        instance.setCriteria(criteria.build());
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-AA");
        expectedIds.add("ID-CR");
        expectedIds.add("ID-NRA");
        expectedIds.add("ID-UFT");
        expectedIds.add("ID-AFL");
        this.testIds(expectedIds, result);
    }

    @Test
    public void testFindLike() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.like((String)"name", (CharSequence)"%Association%")});
        instance.setCriteria(criteria.build());
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-AA");
        expectedIds.add("ID-NRA");
        this.testIds(expectedIds, result);
    }

    @Test
    public void testFindDeepLike() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.like((String)"description", (CharSequence)"%magazine%")});
        instance.setCriteria(criteria.build());
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-CR");
        this.testIds(expectedIds, result);
    }

    @Test
    public void testFindOr() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeId", (Object)"Lobby"), PredicateFactory.equal((String)"active", (Object)"false")})});
        instance.setCriteria(criteria.build());
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-ARP");
        expectedIds.add("ID-NRA");
        expectedIds.add("ID-UFT");
        this.testIds(expectedIds, result);
    }

    @Test
    public void testFindAnd() {
        CriteriaMatcherInMemory instance = new CriteriaMatcherInMemory();
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeId", (Object)"Consumer"), PredicateFactory.equal((String)"active", (Object)"true")})});
        instance.setCriteria(criteria.build());
        Collection result = instance.findMatching(this.getTestContexts());
        LinkedHashSet<String> expectedIds = new LinkedHashSet<String>();
        expectedIds.add("ID-AA");
        expectedIds.add("ID-CR");
        this.testIds(expectedIds, result);
    }

    private void testIds(Set<String> expectedIds, Collection<ContextDefinition> result) {
        for (ContextDefinition info : result) {
            if (expectedIds.remove(info.getId())) continue;
            Assert.fail((String)("Unexpectedly got " + info.getId()));
        }
        if (!expectedIds.isEmpty()) {
            Assert.fail((String)("expected " + expectedIds.size() + " more"));
        }
    }

    @Test
    public void testMatchesEqual() {
        Assert.assertEquals((Object)true, (Object)CriteriaMatcherInMemory.matchesEqual((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesEqual((Object)"a", (Object)"b"));
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesEqual((Object)"b", (Object)"a"));
    }

    @Test
    public void testMatchesLessThan() {
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesLessThan((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)true, (Object)CriteriaMatcherInMemory.matchesLessThan((Object)"a", (Object)"b"));
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesLessThan((Object)"b", (Object)"a"));
    }

    @Test
    public void testMatchesGreaterThan() {
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesGreaterThan((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesGreaterThan((Object)"a", (Object)"b"));
        Assert.assertEquals((Object)true, (Object)CriteriaMatcherInMemory.matchesGreaterThan((Object)"b", (Object)"a"));
    }

    @Test
    public void testMatchesLike() {
        Assert.assertEquals((Object)true, (Object)CriteriaMatcherInMemory.matchesLike((String)"a", (String)"a"));
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesLike((String)"a", (String)"b"));
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesLike((String)"b", (String)"a"));
        Assert.assertEquals((Object)true, (Object)CriteriaMatcherInMemory.matchesLike((String)"b", (String)"%"));
        Assert.assertEquals((Object)true, (Object)CriteriaMatcherInMemory.matchesLike((String)"b", (String)"b%"));
        Assert.assertEquals((Object)false, (Object)CriteriaMatcherInMemory.matchesLike((String)"b", (String)"a%"));
        Assert.assertEquals((Object)true, (Object)CriteriaMatcherInMemory.matchesLike((String)"bbbbba", (String)"%a%"));
    }

    @Test
    public void testExtractValue() {
        ContextDefinition org = this.getTestContexts().get(0);
        Assert.assertEquals((Object)"ID-AA", (Object)CriteriaMatcherInMemory.extractValue((String)"id", (Object)org));
        Assert.assertEquals((Object)"AA", (Object)CriteriaMatcherInMemory.extractValue((String)"namespace", (Object)org));
        Assert.assertEquals((Object)"Automobile Association", (Object)CriteriaMatcherInMemory.extractValue((String)"name", (Object)org));
        Assert.assertEquals((Object)"Consumer", (Object)CriteriaMatcherInMemory.extractValue((String)"typeId", (Object)org));
        Assert.assertEquals((Object)"true", (Object)CriteriaMatcherInMemory.extractValue((String)"active", (Object)org));
        Assert.assertEquals((Object)"Automobile Association towing", (Object)CriteriaMatcherInMemory.extractValue((String)"description", (Object)org));
    }
}

