/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.DataObjectService;

public class BusinessObjectServiceMigrationUtils {
    public static <T> T findSingleMatching(DataObjectService dos, Class<T> entityClass, Map<String, ?> queryAttrs) {
        QueryByCriteria criteria = QueryByCriteria.Builder.andAttributes(queryAttrs).build();
        QueryResults queryResults = dos.findMatching(entityClass, criteria);
        if (queryResults != null && !CollectionUtils.isEmpty((Collection)queryResults.getResults())) {
            List results = queryResults.getResults();
            if (results.size() != 1) {
                throw new IllegalArgumentException("multiple results returned from query");
            }
            return (T)queryResults.getResults().get(0);
        }
        return null;
    }

    public static <T> List<T> findMatching(DataObjectService dos, Class<T> entityClass, Map<String, ?> queryAttrs) {
        QueryByCriteria criteria = QueryByCriteria.Builder.andAttributes(queryAttrs).build();
        QueryResults queryResults = dos.findMatching(entityClass, criteria);
        if (queryResults.getResults() != null) {
            return queryResults.getResults();
        }
        return new ArrayList();
    }

    public static <T> List<T> findMatchingOrderBy(DataObjectService dos, Class<T> entityClass, Map<String, ?> queryAttrs, String orderByField, boolean sortAscending) {
        QueryByCriteria.Builder critBuilder = QueryByCriteria.Builder.andAttributes(queryAttrs);
        OrderDirection sortDirection = sortAscending ? OrderDirection.ASCENDING : OrderDirection.DESCENDING;
        critBuilder.setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)orderByField, (OrderDirection)sortDirection).build()});
        QueryResults queryResults = dos.findMatching(entityClass, critBuilder.build());
        if (queryResults.getResults() != null) {
            return queryResults.getResults();
        }
        return new ArrayList();
    }

    public static <T> void deleteMatching(DataObjectService dos, Class<T> entityClass, Map<String, ?> queryAttrs) {
        QueryByCriteria criteria = QueryByCriteria.Builder.andAttributes(queryAttrs).build();
        dos.deleteMatching(entityClass, criteria);
    }
}

