/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.language;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.KrmsTypeRepositoryServiceImpl;
import org.kuali.rice.krms.impl.repository.language.TranslationContext;
import org.kuali.rice.krms.impl.repository.language.TranslationContextRegistry;
import org.kuali.rice.krms.impl.repository.language.VelocityTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropositionNaturalLanguageTemplater
implements NaturalLanguageTemplaterContract {
    private static final Logger logger = LoggerFactory.getLogger(PropositionNaturalLanguageTemplater.class);
    private TranslationContextRegistry<TranslationContext> translationContextRegistry;
    private KrmsTypeRepositoryService krmsTypeRepositoryService = new KrmsTypeRepositoryServiceImpl();
    public static final String OPERATOR_TOKEN = "relationalOperator";
    public static final String CONSTANT_VALUE_TOKEN = "intValue";
    private VelocityTemplateEngine templateEngine = new VelocityTemplateEngine();

    public void setTranslationContextRegistry(TranslationContextRegistry<TranslationContext> translationContextRegistry) {
        this.translationContextRegistry = translationContextRegistry;
    }

    public String translate(NaturalLanguageTemplate naturalLanguageTemplate, Map<String, Object> parametersMap) {
        if (naturalLanguageTemplate == null) {
            return "";
        }
        Map<String, Object> contextMap = null;
        try {
            contextMap = this.buildContextMap(naturalLanguageTemplate.getTypeId(), parametersMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String nl = this.templateEngine.evaluate(contextMap, naturalLanguageTemplate.getTemplate());
            if (logger.isInfoEnabled()) {
                logger.info("nl=" + nl);
            }
            return nl;
        }
        catch (VelocityException e) {
            String msg = "Generating template for proposition failed: template='" + naturalLanguageTemplate.getTemplate() + "', contextMap=" + contextMap;
            logger.error(msg, (Throwable)e);
            return "Error";
        }
    }

    private Map<String, Object> buildContextMap(String typeId, Map<String, Object> parametersMap) throws Exception {
        KrmsTypeDefinition type;
        List<TranslationContext> translationContextList;
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (parametersMap.containsKey(PropositionParameterType.CONSTANT.getCode())) {
            String constantString = (String)parametersMap.get(PropositionParameterType.CONSTANT.getCode());
            if (StringUtils.isNumeric((String)constantString)) {
                contextMap.put(CONSTANT_VALUE_TOKEN, Integer.valueOf(constantString));
            } else {
                contextMap.put(CONSTANT_VALUE_TOKEN, constantString);
            }
        }
        if (parametersMap.containsKey(PropositionParameterType.OPERATOR.getCode())) {
            String operatorString = (String)parametersMap.get(PropositionParameterType.OPERATOR.getCode());
            contextMap.put(OPERATOR_TOKEN, operatorString);
        }
        if ((translationContextList = this.translationContextRegistry.get((type = this.getKrmsTypeRepositoryService().getTypeById(typeId)).getName())) == null || translationContextList.isEmpty()) {
            return contextMap;
        }
        for (TranslationContext translationContext : translationContextList) {
            Map<String, Object> cm = translationContext.createContextMap(parametersMap);
            contextMap.putAll(cm);
        }
        if (logger.isInfoEnabled()) {
            logger.info("contextMap=" + contextMap);
        }
        return contextMap;
    }

    private KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return this.krmsTypeRepositoryService;
    }

    public void setKrmsTypeRepositoryService(KrmsTypeRepositoryService krmsTypeRepositoryService) {
        this.krmsTypeRepositoryService = krmsTypeRepositoryService;
    }
}

