/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import java.util.List;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;

public class KrmsTypeRelationLoader {
    private KrmsTypeRepositoryService krmsTypeRepositoryService = null;

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return this.krmsTypeRepositoryService;
    }

    public void setKrmsTypeRepositoryService(KrmsTypeRepositoryService krmsTypeRepositoryService) {
        this.krmsTypeRepositoryService = krmsTypeRepositoryService;
    }

    public void loadTypeRelation(String id, String fromTypeId, String toTypeId, String relType, Integer sequenceNumber) {
        RelationshipType relationshipType = RelationshipType.USAGE_ALLOWED;
        if (!relType.equals("A")) {
            relationshipType = RelationshipType.UNKNOWN;
        }
        TypeTypeRelation.Builder bldr = TypeTypeRelation.Builder.create((String)fromTypeId, (RelationshipType)relationshipType, (Integer)sequenceNumber, (String)toTypeId);
        bldr.setId(id);
        bldr.setActive(true);
        TypeTypeRelation existing = this.findExisting(bldr);
        if (existing == null) {
            this.getKrmsTypeRepositoryService().createTypeTypeRelation(bldr.build());
        } else {
            bldr.setVersionNumber(existing.getVersionNumber());
            this.getKrmsTypeRepositoryService().updateTypeTypeRelation(bldr.build());
        }
    }

    private TypeTypeRelation findExisting(TypeTypeRelation.Builder bldr) {
        List list = this.getKrmsTypeRepositoryService().findTypeTypeRelationsByFromType(bldr.getFromTypeId());
        for (TypeTypeRelation rel : list) {
            if (!bldr.getToTypeId().equals(rel.getToTypeId())) continue;
            return rel;
        }
        return null;
    }

    public void load() {
        this.loadTypeRelation("10000", "10000", "10002", "A", 1);
        this.loadTypeRelation("10001", "10000", "10003", "A", 6);
        this.loadTypeRelation("10010", "10001", "10014", "A", 1);
        this.loadTypeRelation("10011", "10001", "10015", "A", 2);
        this.loadTypeRelation("10009", "10001", "10013", "A", 3);
        this.loadTypeRelation("10006", "10002", "10010", "A", 2);
        this.loadTypeRelation("10003", "10002", "10006", "A", 3);
        this.loadTypeRelation("10005", "10002", "10008", "A", 4);
        this.loadTypeRelation("10002", "10002", "10005", "A", 5);
        this.loadTypeRelation("10008", "10003", "10012", "A", 7);
        this.loadTypeRelation("10007", "10003", "10011", "A", 8);
        this.loadTypeRelation("10012", "10004", "10016", "A", 2);
        this.loadTypeRelation("10030", "10005", "10021", "A", 1);
        this.loadTypeRelation("10057", "10005", "10032", "A", 1);
        this.loadTypeRelation("10026", "10005", "10020", "A", 2);
        this.loadTypeRelation("10033", "10005", "10022", "A", 3);
        this.loadTypeRelation("10067", "10005", "10037", "A", 5);
        this.loadTypeRelation("10055", "10006", "10031", "A", 0);
        this.loadTypeRelation("10054", "10006", "10030", "A", 1);
        this.loadTypeRelation("10036", "10006", "10024", "A", 2);
        this.loadTypeRelation("10035", "10006", "10023", "A", 3);
        this.loadTypeRelation("10014", "10008", "10017", "A", 1);
        this.loadTypeRelation("10059", "10009", "10033", "A", 2);
        this.loadTypeRelation("10065", "10009", "10036", "A", 3);
        this.loadTypeRelation("10056", "10010", "10031", "A", 0);
        this.loadTypeRelation("10015", "10010", "10017", "A", 1);
        this.loadTypeRelation("10114", "10010", "10040", "A", 1);
        this.loadTypeRelation("10116", "10010", "10052", "A", 1);
        this.loadTypeRelation("10113", "10010", "10054", "A", 1);
        this.loadTypeRelation("10115", "10010", "10055", "A", 1);
        this.loadTypeRelation("10019", "10010", "10018", "A", 2);
        this.loadTypeRelation("10023", "10010", "10019", "A", 3);
        this.loadTypeRelation("10038", "10010", "10025", "A", 6);
        this.loadTypeRelation("10045", "10010", "10027", "A", 7);
        this.loadTypeRelation("10049", "10010", "10028", "A", 8);
        this.loadTypeRelation("10042", "10010", "10026", "A", 9);
        this.loadTypeRelation("10060", "10010", "10033", "A", 11);
        this.loadTypeRelation("10066", "10010", "10036", "A", 12);
        this.loadTypeRelation("10062", "10010", "10034", "A", 13);
        this.loadTypeRelation("10064", "10010", "10035", "A", 14);
        this.loadTypeRelation("10070", "10010", "10038", "A", 15);
        this.loadTypeRelation("10108", "10010", "10074", "A", 15);
        this.loadTypeRelation("10111", "10010", "10075", "A", 15);
        this.loadTypeRelation("10053", "10011", "10029", "A", 1);
        this.loadTypeRelation("10058", "10012", "10032", "A", 1);
        this.loadTypeRelation("10027", "10012", "10020", "A", 2);
        this.loadTypeRelation("10039", "10013", "10025", "A", 4);
        this.loadTypeRelation("10072", "10013", "10039", "A", 5);
        this.loadTypeRelation("10024", "10013", "10019", "A", 10);
        this.loadTypeRelation("10020", "10013", "10018", "A", 11);
        this.loadTypeRelation("10031", "10013", "10021", "A", 12);
        this.loadTypeRelation("10046", "10013", "10027", "A", 13);
        this.loadTypeRelation("10050", "10013", "10028", "A", 14);
        this.loadTypeRelation("10016", "10013", "10017", "A", 16);
        this.loadTypeRelation("10073", "10013", "10040", "A", 18);
        this.loadTypeRelation("10040", "10014", "10025", "A", 5);
        this.loadTypeRelation("10071", "10014", "10038", "A", 6);
        this.loadTypeRelation("10109", "10014", "10074", "A", 6);
        this.loadTypeRelation("10112", "10014", "10075", "A", 6);
        this.loadTypeRelation("10025", "10014", "10019", "A", 9);
        this.loadTypeRelation("10028", "10014", "10020", "A", 10);
        this.loadTypeRelation("10021", "10014", "10018", "A", 11);
        this.loadTypeRelation("10032", "10014", "10021", "A", 12);
        this.loadTypeRelation("10034", "10014", "10022", "A", 13);
        this.loadTypeRelation("10068", "10014", "10037", "A", 15);
        this.loadTypeRelation("10047", "10014", "10027", "A", 16);
        this.loadTypeRelation("10051", "10014", "10028", "A", 17);
        this.loadTypeRelation("10043", "10014", "10026", "A", 18);
        this.loadTypeRelation("10017", "10014", "10017", "A", 19);
        this.loadTypeRelation("10052", "10015", "10028", "A", 5);
        this.loadTypeRelation("10074", "10015", "10040", "A", 6);
        this.loadTypeRelation("10075", "10015", "10041", "A", 7);
        this.loadTypeRelation("10076", "10016", "10042", "A", 2);
        this.loadTypeRelation("10077", "10016", "10043", "A", 2);
        this.loadTypeRelation("10078", "10016", "10044", "A", 2);
        this.loadTypeRelation("10079", "10016", "10045", "A", 2);
        this.loadTypeRelation("10080", "10016", "10046", "A", 2);
        this.loadTypeRelation("10081", "10016", "10047", "A", 2);
        this.loadTypeRelation("10084", "10016", "10050", "A", 2);
        this.loadTypeRelation("10085", "10016", "10051", "A", 2);
        this.loadTypeRelation("10086", "10016", "10052", "A", 2);
        this.loadTypeRelation("10087", "10016", "10053", "A", 2);
        this.loadTypeRelation("10088", "10016", "10054", "A", 2);
        this.loadTypeRelation("10089", "10016", "10055", "A", 2);
        this.loadTypeRelation("10090", "10016", "10056", "A", 2);
        this.loadTypeRelation("10091", "10016", "10057", "A", 2);
        this.loadTypeRelation("10092", "10016", "10058", "A", 2);
        this.loadTypeRelation("10093", "10016", "10059", "A", 2);
        this.loadTypeRelation("10094", "10016", "10060", "A", 2);
        this.loadTypeRelation("10095", "10016", "10061", "A", 2);
        this.loadTypeRelation("10096", "10016", "10062", "A", 2);
        this.loadTypeRelation("10098", "10016", "10064", "A", 2);
        this.loadTypeRelation("10099", "10016", "10065", "A", 2);
        this.loadTypeRelation("10100", "10016", "10066", "A", 2);
        this.loadTypeRelation("10101", "10016", "10067", "A", 2);
        this.loadTypeRelation("10102", "10016", "10068", "A", 2);
        this.loadTypeRelation("10103", "10016", "10069", "A", 2);
        this.loadTypeRelation("10105", "10016", "10071", "A", 2);
        this.loadTypeRelation("10106", "10016", "10072", "A", 2);
        this.loadTypeRelation("10019-A-10100", "10019", "10100", "A", 1);
        this.loadTypeRelation("10019-A-10102", "10019", "10102", "A", 2);
        this.loadTypeRelation("10019-A-10101", "10019", "10101", "A", 3);
        this.loadTypeRelation("10100-A-10104", "10100", "10104", "A", 1);
    }
}

