/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.bam.service.impl;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMParam;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.bam.service.BAMService;

public class BAMServiceImpl
implements BAMService {
    private static final Logger LOG = Logger.getLogger(BAMServiceImpl.class);
    private DataObjectService dataObjectService;

    @Override
    public BAMTargetEntry recordClientInvocation(ServiceConfiguration serviceConfiguration, Object target, Method method, Object[] params) {
        if (this.isEnabled()) {
            try {
                LOG.debug((Object)("A call was received... for service: " + serviceConfiguration.getServiceName().toString() + " method: " + method.getName()));
                BAMTargetEntry bamTargetEntry = this.getBAMTargetEntry(Boolean.FALSE, serviceConfiguration, target, method, params);
                return (BAMTargetEntry)this.dataObjectService.save((Object)bamTargetEntry, new PersistenceOption[]{PersistenceOption.FLUSH});
            }
            catch (Throwable t) {
                LOG.error((Object)"BAM Failed to record client invocation", t);
            }
        }
        return null;
    }

    @Override
    public BAMTargetEntry recordServerInvocation(Object target, ServiceDefinition serviceDefinition, Method method, Object[] params) {
        if (this.isEnabled()) {
            try {
                LOG.debug((Object)("A call was received... for service: " + target.getClass().getName() + " method: " + method.getName()));
                BAMTargetEntry bamTargetEntry = this.getBAMTargetEntry(Boolean.TRUE, serviceDefinition, target, method, params);
                return (BAMTargetEntry)this.dataObjectService.save((Object)bamTargetEntry, new PersistenceOption[]{PersistenceOption.FLUSH});
            }
            catch (Throwable t) {
                LOG.error((Object)"BAM Failed to record server invocation", t);
            }
        }
        return null;
    }

    @Override
    public BAMTargetEntry recordClientInvocationError(Throwable throwable, BAMTargetEntry bamTargetEntry) {
        if (bamTargetEntry != null) {
            try {
                this.setThrowableOnBAMTargetEntry(throwable, bamTargetEntry);
                return (BAMTargetEntry)this.dataObjectService.save((Object)bamTargetEntry, new PersistenceOption[]{PersistenceOption.FLUSH});
            }
            catch (Exception e) {
                LOG.error((Object)"BAM Failed to record client invocation error", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public BAMTargetEntry recordServerInvocationError(Throwable throwable, BAMTargetEntry bamTargetEntry) {
        if (bamTargetEntry != null) {
            try {
                this.setThrowableOnBAMTargetEntry(throwable, bamTargetEntry);
                return (BAMTargetEntry)this.dataObjectService.save((Object)bamTargetEntry, new PersistenceOption[]{PersistenceOption.FLUSH});
            }
            catch (Exception e) {
                LOG.error((Object)"BAM Failed to record service invocation error", (Throwable)e);
            }
        }
        return null;
    }

    private void setThrowableOnBAMTargetEntry(Throwable throwable, BAMTargetEntry bamTargetEntry) {
        if (throwable != null) {
            bamTargetEntry.setExceptionMessage(throwable.getMessage());
            bamTargetEntry.setExceptionToString(this.makeStringfit(throwable.toString()));
        }
    }

    private BAMTargetEntry getBAMTargetEntry(Boolean serverInd, ServiceConfiguration serviceConfiguration, Object target, Method method, Object[] params) {
        BAMTargetEntry bamEntry = new BAMTargetEntry();
        bamEntry.setServerInvocation(serverInd);
        bamEntry.setServiceName(serviceConfiguration.getServiceName().toString());
        bamEntry.setServiceURL(serviceConfiguration.getEndpointUrl().toExternalForm());
        bamEntry.setTargetToString(this.makeStringfit(target.toString()));
        bamEntry.setMethodName(method.getName());
        bamEntry.setThreadName(Thread.currentThread().getName());
        bamEntry.setCallDate(new Timestamp(System.currentTimeMillis()));
        this.setBamParams(params, bamEntry);
        return bamEntry;
    }

    private BAMTargetEntry getBAMTargetEntry(Boolean serverInd, ServiceDefinition serviceDefinition, Object target, Method method, Object[] params) {
        BAMTargetEntry bamEntry = new BAMTargetEntry();
        bamEntry.setServerInvocation(serverInd);
        bamEntry.setServiceName(serviceDefinition.getServiceName().toString());
        bamEntry.setServiceURL(serviceDefinition.getEndpointUrl().toExternalForm());
        bamEntry.setTargetToString(this.makeStringfit(target.toString()));
        bamEntry.setMethodName(method.getName());
        bamEntry.setThreadName(Thread.currentThread().getName());
        bamEntry.setCallDate(new Timestamp(System.currentTimeMillis()));
        this.setBamParams(params, bamEntry);
        return bamEntry;
    }

    private void setBamParams(Object[] params, BAMTargetEntry bamEntry) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            BAMParam bamParam = new BAMParam();
            bamParam.setBamTargetEntry(bamEntry);
            bamParam.setParam(params[i].toString());
            bamEntry.addBamParam(bamParam);
        }
    }

    private String makeStringfit(String string) {
        if (string.length() > 1999) {
            return string.substring(0, 1999);
        }
        return string;
    }

    public boolean isEnabled() {
        return Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("bam.enabled"));
    }

    @Override
    public List<BAMTargetEntry> getCallsForService(QName serviceName) {
        return this.getCallsForService(serviceName, null);
    }

    @Override
    public List<BAMTargetEntry> getCallsForService(QName serviceName, String methodName) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"serviceName", (Object)serviceName.toString()));
        if (StringUtils.isNotBlank((String)methodName)) {
            predicates.add(PredicateFactory.equal((String)"methodName", (Object)methodName));
        }
        builder.setPredicates(predicates.toArray(new Predicate[predicates.size()]));
        return this.dataObjectService.findMatching(BAMTargetEntry.class, builder.build()).getResults();
    }

    @Override
    public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef) {
        return this.getCallsForRemotedClasses(objDef, null);
    }

    @Override
    public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef, String methodName) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        QName qname = new QName(objDef.getApplicationId(), objDef.getClassName());
        predicates.add(PredicateFactory.like((String)"serviceName", (CharSequence)(qname.toString() + "*")));
        if (StringUtils.isNotBlank((String)methodName)) {
            predicates.add(PredicateFactory.equal((String)"methodName", (Object)methodName));
        }
        builder.setPredicates(predicates.toArray(new Predicate[predicates.size()]));
        return this.dataObjectService.findMatching(BAMTargetEntry.class, builder.build()).getResults();
    }

    @Override
    public void clearBAMTables() {
        this.dataObjectService.deleteAll(BAMTargetEntry.class);
        this.dataObjectService.deleteAll(BAMParam.class);
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

