/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.messaging.serviceconnectors.HttpClientConfigurer;
import org.kuali.rice.ksb.messaging.serviceconnectors.HttpClientParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultHttpClientConfigurer
implements HttpClientConfigurer,
InitializingBean {
    static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClientConfigurer.class);
    private static final String RETRY_SOCKET_EXCEPTION_PROPERTY = "ksb.thinClient.retrySocketException";
    private static final int DEFAULT_SOCKET_TIMEOUT = 120000;
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private static final Set<String> unsupportedParamsWhitelist = new HashSet<String>(Arrays.asList("http.port", "http.service.url"));

    @Override
    public void customizeHttpClient(HttpClientBuilder httpClientBuilder) {
        HttpRequestRetryHandler retryHandler;
        RequestConfig requestConfig;
        HttpClientConnectionManager connectionManager = this.buildConnectionManager();
        if (connectionManager != null) {
            httpClientBuilder.setConnectionManager(connectionManager);
        }
        if ((requestConfig = this.buildRequestConfig()) != null) {
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
        }
        if ((retryHandler = this.buildRetryHandler()) != null) {
            httpClientBuilder.setRetryHandler(retryHandler);
        }
    }

    protected HttpClientConnectionManager buildConnectionManager() {
        String contentCharset;
        Boolean isTcpNoDelay;
        PoolingHttpClientConnectionManager poolingConnectionManager = null;
        SSLConnectionSocketFactory sslConnectionSocketFactory = this.buildSslConnectionSocketFactory();
        if (sslConnectionSocketFactory != null) {
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            poolingConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        } else {
            poolingConnectionManager = new PoolingHttpClientConnectionManager();
        }
        poolingConnectionManager.setMaxTotal(HttpClientParams.MAX_TOTAL_CONNECTIONS.getValueOrDefault(20).intValue());
        poolingConnectionManager.setDefaultMaxPerRoute(HttpClientParams.MAX_TOTAL_CONNECTIONS.getValueOrDefault(20).intValue());
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(HttpClientParams.SO_TIMEOUT.getValueOrDefault(120000).intValue());
        Integer soLinger = (Integer)HttpClientParams.SO_LINGER.getValue();
        if (soLinger != null) {
            socketConfigBuilder.setSoLinger(soLinger.intValue());
        }
        if ((isTcpNoDelay = (Boolean)HttpClientParams.TCP_NODELAY.getValue()) != null) {
            socketConfigBuilder.setTcpNoDelay(isTcpNoDelay.booleanValue());
        }
        poolingConnectionManager.setDefaultSocketConfig(socketConfigBuilder.build());
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        Integer sendBuffer = (Integer)HttpClientParams.SO_SNDBUF.getValue();
        Integer receiveBuffer = (Integer)HttpClientParams.SO_RCVBUF.getValue();
        if (sendBuffer != null || receiveBuffer != null) {
            Integer bufferSize = -1;
            if (sendBuffer != null) {
                bufferSize = sendBuffer;
            }
            if (receiveBuffer != null && receiveBuffer > bufferSize) {
                bufferSize = receiveBuffer;
            }
            connectionConfigBuilder.setBufferSize(bufferSize.intValue());
        }
        if ((contentCharset = (String)HttpClientParams.HTTP_CONTENT_CHARSET.getValue()) != null) {
            connectionConfigBuilder.setCharset(Charset.forName(contentCharset));
        }
        poolingConnectionManager.setDefaultConnectionConfig(connectionConfigBuilder.build());
        return poolingConnectionManager;
    }

    protected HttpRequestRetryHandler buildRetryHandler() {
        if (ConfigContext.getCurrentContextConfig().getBooleanProperty(RETRY_SOCKET_EXCEPTION_PROPERTY, false)) {
            return new DefaultHttpRequestRetryHandler(1, true);
        }
        return null;
    }

    protected RequestConfig buildRequestConfig() {
        Boolean isRejectRelativeRedirects;
        Boolean isCircularRedirectsAllowed;
        Integer maxRedirects;
        Boolean isStaleConnectionCheckEnabled;
        Integer connectionTimeout;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec(HttpClientParams.COOKIE_POLICY.getValueOrDefault("standard"));
        Integer connectionRequestTimeout = (Integer)HttpClientParams.CONNECTION_MANAGER_TIMEOUT.getValue();
        if (connectionRequestTimeout != null) {
            requestConfigBuilder.setConnectionRequestTimeout(connectionRequestTimeout.intValue());
        }
        if ((connectionTimeout = (Integer)HttpClientParams.CONNECTION_TIMEOUT.getValue()) != null) {
            requestConfigBuilder.setConnectTimeout(connectionTimeout.intValue());
        }
        if ((isStaleConnectionCheckEnabled = (Boolean)HttpClientParams.STALE_CONNECTION_CHECK.getValue()) != null) {
            requestConfigBuilder.setStaleConnectionCheckEnabled(isStaleConnectionCheckEnabled.booleanValue());
        }
        requestConfigBuilder.setSocketTimeout(HttpClientParams.SO_TIMEOUT.getValueOrDefault(120000).intValue());
        Boolean isUseExpectContinue = (Boolean)HttpClientParams.USE_EXPECT_CONTINUE.getValue();
        if (isUseExpectContinue != null) {
            requestConfigBuilder.setExpectContinueEnabled(isUseExpectContinue.booleanValue());
        }
        if ((maxRedirects = (Integer)HttpClientParams.MAX_REDIRECTS.getValue()) != null) {
            requestConfigBuilder.setMaxRedirects(maxRedirects.intValue());
        }
        if ((isCircularRedirectsAllowed = (Boolean)HttpClientParams.ALLOW_CIRCULAR_REDIRECTS.getValue()) != null) {
            requestConfigBuilder.setCircularRedirectsAllowed(isCircularRedirectsAllowed.booleanValue());
        }
        if ((isRejectRelativeRedirects = (Boolean)HttpClientParams.REJECT_RELATIVE_REDIRECT.getValue()) != null) {
            requestConfigBuilder.setRelativeRedirectsAllowed(isRejectRelativeRedirects == false);
        }
        return requestConfigBuilder.build();
    }

    protected SSLConnectionSocketFactory buildSslConnectionSocketFactory() {
        SSLContextBuilder builder = new SSLContextBuilder();
        if (ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.ksb.config.allowSelfSignedSSL").booleanValue()) {
            try {
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RiceRuntimeException((Throwable)e);
            }
            catch (KeyStoreException e) {
                throw new RiceRuntimeException((Throwable)e);
            }
        }
        SSLConnectionSocketFactory sslsf = null;
        try {
            sslsf = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.ksb.config.allowSelfSignedSSL").booleanValue() ? new SSLConnectionSocketFactory(builder.build(), (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(builder.build());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RiceRuntimeException((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new RiceRuntimeException((Throwable)e);
        }
        return sslsf;
    }

    public void afterPropertiesSet() throws Exception {
        this.customizeHttpClient(HttpClientBuilder.create());
        Map httpParams = ConfigContext.getCurrentContextConfig().getPropertiesWithPrefix("http.", false);
        for (Map.Entry paramEntry : httpParams.entrySet()) {
            if (this.isParamNameSupported((String)paramEntry.getKey()) || unsupportedParamsWhitelist.contains(paramEntry)) continue;
            LOG.warn("Ignoring unsupported config param \"" + (String)paramEntry.getKey() + "\" with value \"" + (String)paramEntry.getValue() + "\"");
        }
    }

    private boolean isParamNameSupported(String paramName) {
        for (HttpClientParams param : HttpClientParams.values()) {
            if (!param.getParamName().equals(paramName)) continue;
            return true;
        }
        return false;
    }
}

