/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.messaging.web.KSBAction;
import org.kuali.rice.ksb.messaging.web.ServiceRegistryForm;

public class ServiceRegistryAction
extends KSBAction {
    private static final String REMOVED_APPLICATION_ID_PARAM = "removedApplicationId";
    private static final Logger LOG = Logger.getLogger(ServiceRegistryAction.class);

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return mapping.findForward("basic");
    }

    public ActionForward refreshServiceRegistry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        KsbApiServiceLocator.getServiceBus().synchronize();
        return mapping.findForward("basic");
    }

    public ActionForward deleteLocalhostEntries(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServiceRegistry serviceRegistry = KsbApiServiceLocator.getServiceRegistry();
        List serviceInfos = serviceRegistry.getAllOnlineServices();
        ArrayList<String> serviceEndpointsToDelete = new ArrayList<String>();
        for (ServiceInfo serviceInfo : serviceInfos) {
            if (!serviceInfo.getServerIpAddress().equals("localhost") && !serviceInfo.getEndpointUrl().contains("localhost")) continue;
            serviceEndpointsToDelete.add(serviceInfo.getServiceId());
        }
        serviceRegistry.removeServiceEndpoints(serviceEndpointsToDelete);
        KsbApiServiceLocator.getServiceBus().synchronize();
        return mapping.findForward("basic");
    }

    public ActionForward deleteApplicationIdEntries(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String applicationId = request.getParameter(REMOVED_APPLICATION_ID_PARAM);
        if (StringUtils.isNotBlank((String)applicationId)) {
            ServiceRegistry serviceRegistry = KsbApiServiceLocator.getServiceRegistry();
            List serviceInfos = serviceRegistry.getAllOnlineServices();
            ArrayList<String> serviceEndpointsToDelete = new ArrayList<String>();
            for (ServiceInfo serviceInfo : serviceInfos) {
                if (!serviceInfo.getApplicationId().equals(applicationId)) continue;
                serviceEndpointsToDelete.add(serviceInfo.getServiceId());
            }
            serviceRegistry.removeServiceEndpoints(serviceEndpointsToDelete);
            KsbApiServiceLocator.getServiceBus().synchronize();
        } else {
            LOG.info((Object)"No rows were deleted from the KRSB_SVC_DEF_T table because the application ID was null or blank.");
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm actionForm) throws Exception {
        ServiceRegistryForm form = (ServiceRegistryForm)actionForm;
        form.setMyIpAddress(RiceUtilities.getIpNumber());
        form.setMyApplicationId(CoreConfigHelper.getApplicationId());
        form.setDevMode(ConfigContext.getCurrentContextConfig().getDevMode());
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        form.setMyInstanceId(serviceBus.getInstanceId());
        form.setPublishedServices(this.getPublishedServices(serviceBus));
        ServiceRegistry serviceRegistry = KsbApiServiceLocator.getServiceRegistry();
        form.setGlobalRegistryServices(this.getGlobalRegistryServices(serviceRegistry));
        return null;
    }

    private List<ServiceConfiguration> getPublishedServices(ServiceBus serviceBus) {
        Map localEndpoints = serviceBus.getLocalEndpoints();
        ArrayList<ServiceConfiguration> publishedServices = new ArrayList<ServiceConfiguration>();
        for (Endpoint endpoint : localEndpoints.values()) {
            publishedServices.add(endpoint.getServiceConfiguration());
        }
        return publishedServices;
    }

    private List<ServiceInfo> getGlobalRegistryServices(ServiceRegistry serviceRegistry) {
        return serviceRegistry.getAllServices();
    }
}

