/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class WebDriverScreenshotHelper {
    private static final String REMOTE_DRIVER_SCREENSHOT_FILENAME = "remote.driver.screenshot.filename";
    private static final String REMOTE_DRIVER_SCREENSHOT_DIR = "remote.driver.screenshot.dir";
    private static final String REMOTE_DRIVER_SCREENSHOT_ARCHIVE_URL = "remote.driver.screenshot.archive.url";
    private static final String REMOTE_DRIVER_FAILURE_SCREENSHOT = "remote.driver.failure.screenshot";
    private static final String REMOTE_DRIVER_STEP_SCREENSHOT = "remote.driver.step.screenshot";

    public void screenshot(WebDriver driver, String testName, String testMethodName) throws IOException {
        this.screenshot(driver, testName, testMethodName, "");
    }

    public void screenshot(WebDriver driver, String testName, String testMethodName, String screenName) throws IOException {
        if (driver instanceof TakesScreenshot) {
            if (!"".equals(screenName)) {
                screenName = "-" + screenName;
            }
            File scrFile = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            String screenshotFileName = WebDriverUtils.getDateTimeStampFormatted() + "-" + System.getProperty(REMOTE_DRIVER_SCREENSHOT_FILENAME, testName + "." + testMethodName) + screenName + ".png";
            FileUtils.copyFile((File)scrFile, (File)new File(System.getProperty(REMOTE_DRIVER_SCREENSHOT_DIR, ".") + File.separator, screenshotFileName));
            String archiveUrl = System.getProperty(REMOTE_DRIVER_SCREENSHOT_ARCHIVE_URL, "");
            WebDriverUtils.jGrowl(driver, "Screenshot", false, archiveUrl + screenshotFileName);
        }
    }

    public boolean screenshotOnFailure() {
        return "true".equals(System.getProperty(REMOTE_DRIVER_FAILURE_SCREENSHOT, "false"));
    }

    public boolean screenshotSteps() {
        return "true".equals(System.getProperty(REMOTE_DRIVER_STEP_SCREENSHOT, "false"));
    }
}

