/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.health.HealthCheck;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.web.health.DatabaseConnectionPoolHealthCheck;
import org.kuali.rice.web.health.TestGauge;

public class DatabaseConnectionPoolHealthCheckTest {
    private DatabaseConnectionPoolHealthCheck healthCheck;
    private TestGauge gauge;

    @Before
    public void setUp() {
        this.gauge = new TestGauge();
        this.healthCheck = new DatabaseConnectionPoolHealthCheck((Gauge)this.gauge, 0.5);
    }

    @Test
    public void testCheck_Healthy_UnderThreshold() throws Exception {
        this.gauge.setValue(0.25);
        HealthCheck.Result result = this.healthCheck.check();
        Assert.assertTrue((String)"Result should be healthy since value is below threshold", (boolean)result.isHealthy());
    }

    @Test
    public void testCheck_Unhealhty_OverThreshold() throws Exception {
        this.gauge.setValue(0.75);
        HealthCheck.Result result = this.healthCheck.check();
        Assert.assertFalse((String)"Result should be unhealthy since value is above threshold", (boolean)result.isHealthy());
    }

    @Test
    public void testCheck_Unhealhty_EqualThreshold() throws Exception {
        this.gauge.setValue(0.5);
        HealthCheck.Result result = this.healthCheck.check();
        Assert.assertFalse((String)"Result should be unhealthy since value is equal to the threshold", (boolean)result.isHealthy());
    }
}

