/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.web.health.HealthMetric;

public class HealthMetricTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstructor_Null_Name() {
        new HealthMetric(null, (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor_Blank_Name() {
        new HealthMetric("", (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor_Bad_Name_No_Colon() {
        new HealthMetric("blah", (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor_Bad_Name_Before_Colon() {
        new HealthMetric(":after", (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor_Bad_Name_After_Colon() {
        new HealthMetric("before:", (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor_Bad_Name_Just_A_Colon() {
        new HealthMetric(":", (Object)"value");
    }

    @Test
    public void testConstructor() {
        HealthMetric metric = new HealthMetric("before:after", (Object)"value");
        Assert.assertEquals((Object)"before", (Object)metric.getMeasure());
        Assert.assertEquals((Object)"after", (Object)metric.getMetric());
        Assert.assertEquals((Object)"value", (Object)metric.getValue());
    }

    @Test
    public void testConstructor_Null_Value() {
        HealthMetric metric = new HealthMetric("before:after", null);
        Assert.assertNull((Object)metric.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFullConstructor_Null_Measure() {
        new HealthMetric(null, "metric", (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFullConstructor_Blank_Measure() {
        new HealthMetric("", "metric", (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFullConstructor_Null_Metric() {
        new HealthMetric("measure", null, (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFullConstructor_Blank_Metric() {
        new HealthMetric("measure", "", (Object)"value");
    }

    @Test
    public void testFullConstructor() {
        HealthMetric metric = new HealthMetric("measure", "metric", (Object)"value");
        Assert.assertEquals((Object)"measure", (Object)metric.getMeasure());
        Assert.assertEquals((Object)"metric", (Object)metric.getMetric());
        Assert.assertEquals((Object)"value", (Object)metric.getValue());
    }

    @Test
    public void testFullConstructor_Null_Value() {
        HealthMetric metric = new HealthMetric("measure", "metric", null);
        Assert.assertNull((Object)metric.getValue());
    }

    @Test
    public void testJsonSerialization() throws Exception {
        HealthMetric metric = new HealthMetric("my-measure", "my-metric", (Object)"abcdefg");
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)metric);
        Assert.assertEquals((Object)"{\"Measure\":\"my-measure\",\"Metric\":\"my-metric\",\"Value\":\"abcdefg\"}", (Object)json);
    }

    @Test
    public void testJsonSerialization_Null_Value() throws Exception {
        HealthMetric metric = new HealthMetric("my-measure", "my-metric", null);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)metric);
        Assert.assertEquals((Object)"{\"Measure\":\"my-measure\",\"Metric\":\"my-metric\",\"Value\":null}", (Object)json);
    }
}

