/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.resourceloader.ServiceLocator;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.kuali.rice.core.framework.resourceloader.SimpleServiceLocator;
import org.kuali.rice.web.health.HealthServlet;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class HealthServletTest {
    @Mock
    private StandardXAPoolDataSource primaryDataSource;
    @Mock
    private BasicDataSource nonTransactionalDataSource;
    @Mock
    private PoolingDataSource serverDataSource;
    @Mock
    private DatabasePlatform databasePlatform;
    private SimpleConfig config;
    private SimpleServiceLocator serviceLocator;
    private HealthServlet healthServlet;

    @Before
    public void setUp() throws Exception {
        this.config = new SimpleConfig();
        this.config.putProperty("application.id", HealthServletTest.class.getName());
        this.config.putObject("datasource", (Object)this.primaryDataSource);
        this.config.putObject("nonTransactionalDatasource", (Object)this.nonTransactionalDataSource);
        this.config.putObject("serverDatasource", (Object)this.serverDataSource);
        ConfigContext.init((Config)this.config);
        this.stubDataSource((DataSource)this.primaryDataSource);
        this.stubDataSource((DataSource)this.nonTransactionalDataSource);
        this.stubDataSource((DataSource)this.serverDataSource);
        this.serviceLocator = new SimpleServiceLocator();
        this.serviceLocator.addService(new QName("dbPlatform"), (Object)this.databasePlatform);
        GlobalResourceLoader.addResourceLoaderFirst((ResourceLoader)new BaseResourceLoader(new QName(HealthServletTest.class.getName()), (ServiceLocator)this.serviceLocator));
        GlobalResourceLoader.start();
        this.stubDatabasePlatform(this.databasePlatform);
        this.healthServlet = new HealthServlet();
    }

    private void stubDataSource(DataSource dataSource) throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)connection.createStatement()).thenReturn((Object)statement);
        if (dataSource instanceof StandardXAPoolDataSource) {
            StandardXAPoolDataSource ds = (StandardXAPoolDataSource)dataSource;
            Mockito.when((Object)ds.getLockedObjectCount()).thenReturn((Object)10);
            Mockito.when((Object)ds.getMinSize()).thenReturn((Object)5);
            Mockito.when((Object)ds.getMaxSize()).thenReturn((Object)20);
        } else if (dataSource instanceof PoolingDataSource) {
            PoolingDataSource ds = (PoolingDataSource)dataSource;
            Mockito.when((Object)ds.getTotalPoolSize()).thenReturn((Object)15L);
            Mockito.when((Object)ds.getInPoolSize()).thenReturn((Object)5L);
            Mockito.when((Object)ds.getMinPoolSize()).thenReturn((Object)5);
            Mockito.when((Object)ds.getMaxPoolSize()).thenReturn((Object)20);
        } else if (dataSource instanceof BasicDataSource) {
            BasicDataSource ds = (BasicDataSource)dataSource;
            Mockito.when((Object)ds.getNumActive()).thenReturn((Object)10);
            Mockito.when((Object)ds.getMinIdle()).thenReturn((Object)5);
            Mockito.when((Object)ds.getMaxActive()).thenReturn((Object)20);
        } else {
            Assert.fail((String)("Invalid datasource class: " + dataSource.getClass()));
        }
    }

    private void stubDatabasePlatform(DatabasePlatform platform) {
        Mockito.when((Object)platform.getValidationQuery()).thenReturn((Object)"select 1");
        Assert.assertEquals((Object)"select 1", (Object)platform.getValidationQuery());
    }

    @After
    public void tearDown() throws Exception {
        ConfigContext.init((Config)new SimpleConfig());
        GlobalResourceLoader.stop();
    }

    @Test
    public void testService_No_Details_Ok() throws Exception {
        this.healthServlet.init();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost:8080/rice-standalone/health");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.healthServlet.service((ServletRequest)request, (ServletResponse)response);
        Assert.assertEquals((String)"Response code should be 204", (long)204L, (long)response.getStatus());
        String content = response.getContentAsString();
        Assert.assertTrue((String)"Content should be empty", (boolean)content.isEmpty());
    }

    @Test
    public void testService_No_Details_Failed() throws Exception {
        this.config.putProperty("rice.health.memory.total.usageThreshold", "0.0");
        this.healthServlet.init();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost:8080/rice-standalone/health");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.healthServlet.service((ServletRequest)request, (ServletResponse)response);
        Assert.assertEquals((String)"Response code should be 503", (long)503L, (long)response.getStatus());
        String content = response.getContentAsString();
        Assert.assertTrue((String)"Content should be empty", (boolean)content.isEmpty());
    }

    @Test
    public void testService_Details_Ok() throws Exception {
        ConfigContext.init((Config)this.config);
        MockHttpServletResponse response = this.initAndExecuteDetailedCheck(this.healthServlet);
        Assert.assertEquals((String)"Response code should be 200", (long)200L, (long)response.getStatus());
        JsonNode root = this.parseContent(response.getContentAsString());
        Assert.assertEquals((Object)"Ok", (Object)root.get("Status").asText());
        Assert.assertFalse((boolean)root.has("Message"));
        Map<String, String> metricMap = this.loadMetricMap(root);
        Assert.assertEquals((Object)"true", (Object)metricMap.get("database.primary:connected"));
        Assert.assertEquals((Object)"true", (Object)metricMap.get("database.non-transactional:connected"));
        Assert.assertEquals((Object)"true", (Object)metricMap.get("database.server:connected"));
        Assert.assertEquals((Object)"20", (Object)metricMap.get("database.primary:pool.max"));
        Assert.assertEquals((Object)"20", (Object)metricMap.get("database.non-transactional:pool.max"));
        Assert.assertEquals((Object)"20", (Object)metricMap.get("database.server:pool.max"));
        Assert.assertTrue((String)"At least one metric name should start with 'buffer-pool:'", (boolean)this.containsKeyStartsWith("buffer-pool:", metricMap));
        String classloaderLoadedValue = metricMap.get("classloader:loaded");
        Assert.assertNotNull((Object)classloaderLoadedValue);
        Assert.assertTrue((Long.parseLong(classloaderLoadedValue) > 0L ? 1 : 0) != 0);
        String fileDescriptorUsageValue = metricMap.get("file-descriptor:usage");
        Assert.assertNotNull((Object)fileDescriptorUsageValue);
        double fileDescriptorUsage = Double.parseDouble(fileDescriptorUsageValue);
        Assert.assertTrue((fileDescriptorUsage > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((fileDescriptorUsage < 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"At least one metric name should start with 'garbage-collector:'", (boolean)this.containsKeyStartsWith("garbage-collector:", metricMap));
        String totalMemoryUsageValue = metricMap.get("memory:total.usage");
        Assert.assertNotNull((Object)totalMemoryUsageValue);
        double totalMemoryUsage = Double.parseDouble(totalMemoryUsageValue);
        Assert.assertTrue((totalMemoryUsage > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((totalMemoryUsage < 1.0 ? 1 : 0) != 0);
        String uptimeValue = metricMap.get("runtime:uptime");
        Assert.assertNotNull((Object)uptimeValue);
        Assert.assertTrue((Long.parseLong(uptimeValue) > 0L ? 1 : 0) != 0);
        String deadlockCountValue = metricMap.get("thread:deadlock.count");
        Assert.assertNotNull((Object)deadlockCountValue);
        Assert.assertEquals((long)0L, (long)Integer.parseInt(deadlockCountValue));
    }

    @Test
    public void testService_Details_Failed_HeapMemoryThreshold() throws Exception {
        this.config.putProperty("rice.health.memory.heap.usageThreshold", "0");
        ConfigContext.init((Config)this.config);
        MockHttpServletResponse response = this.initAndExecuteDetailedCheck(this.healthServlet);
        Assert.assertEquals((String)"Response code should be 503", (long)503L, (long)response.getStatus());
        JsonNode root = this.parseContent(response.getContentAsString());
        Assert.assertEquals((Object)"Failed", (Object)root.get("Status").asText());
        Assert.assertTrue((boolean)root.has("Message"));
    }

    @Test
    public void testService_Details_Failed_TotalMemoryThreshold() throws Exception {
        this.config.putProperty("rice.health.memory.total.usageThreshold", "0");
        ConfigContext.init((Config)this.config);
        this.assertFailedResponse(this.healthServlet);
    }

    @Test
    public void testService_Details_Failed_DeadlockThreshold() throws Exception {
        this.config.putProperty("rice.health.thread.deadlockThreshold", "0");
        ConfigContext.init((Config)this.config);
        this.assertFailedResponse(this.healthServlet);
    }

    @Test
    public void testService_Details_Failed_FileDescriptorThreshold() throws Exception {
        this.config.putProperty("rice.health.fileDescriptor.usageThreshold", "0");
        ConfigContext.init((Config)this.config);
        this.assertFailedResponse(this.healthServlet);
    }

    @Test
    public void testService_Details_Failed_PrimaryPoolUsageThreshold() throws Exception {
        this.config.putProperty("rice.health.database.primary.connectionPoolUsageThreshold", "0");
        ConfigContext.init((Config)this.config);
        this.assertFailedResponse(this.healthServlet);
    }

    @Test
    public void testService_Details_Failed_NonTransactionalPoolUsageThreshold() throws Exception {
        this.config.putProperty("rice.health.database.nonTransactional.connectionPoolUsageThreshold", "0");
        ConfigContext.init((Config)this.config);
        this.assertFailedResponse(this.healthServlet);
    }

    @Test
    public void testService_Details_Failed_ServerPoolUsageThreshold() throws Exception {
        this.config.putProperty("rice.health.database.server.connectionPoolUsageThreshold", "0");
        ConfigContext.init((Config)this.config);
        this.assertFailedResponse(this.healthServlet);
    }

    @Test
    public void testService_Details_Multiple_Failures() throws Exception {
        this.config.putProperty("rice.health.database.primary.connectionPoolUsageThreshold", "0");
        this.config.putProperty("rice.health.database.nonTransactional.connectionPoolUsageThreshold", "0");
        this.config.putProperty("rice.health.database.server.connectionPoolUsageThreshold", "0");
        ConfigContext.init((Config)this.config);
        MockHttpServletResponse response = this.initAndExecuteDetailedCheck(this.healthServlet);
        Assert.assertEquals((String)"Response code should be 503", (long)503L, (long)response.getStatus());
        JsonNode root = this.parseContent(response.getContentAsString());
        Assert.assertEquals((Object)"Failed", (Object)root.get("Status").asText());
        Assert.assertTrue((boolean)root.has("Message"));
        String message = root.get("Message").asText();
        Assert.assertFalse((boolean)StringUtils.isBlank((String)message));
        Pattern pattern = Pattern.compile("\\* database\\.primary:pool\\.usage -> .+");
        Matcher matcher = pattern.matcher(message);
        Assert.assertTrue((boolean)matcher.find());
        pattern = Pattern.compile("\\* database\\.non-transactional:pool\\.usage -> .+");
        matcher = pattern.matcher(message);
        Assert.assertTrue((boolean)matcher.find());
        pattern = Pattern.compile("\\* database\\.server:pool\\.usage -> .+");
        matcher = pattern.matcher(message);
        Assert.assertTrue((boolean)matcher.find());
        pattern = Pattern.compile("\\* ");
        matcher = pattern.matcher(message);
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertFalse((boolean)matcher.find());
    }

    private MockHttpServletResponse initAndExecuteDetailedCheck(HealthServlet healthServlet) throws Exception {
        healthServlet.init();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost:8080/rice-standalone/health");
        request.setMethod("GET");
        request.setParameter("detail", "true");
        MockHttpServletResponse response = new MockHttpServletResponse();
        healthServlet.service((ServletRequest)request, (ServletResponse)response);
        String content = response.getContentAsString();
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertFalse((boolean)content.isEmpty());
        return response;
    }

    private JsonNode parseContent(String content) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(content);
    }

    private Map<String, String> loadMetricMap(JsonNode root) {
        HashMap<String, String> metricMap = new HashMap<String, String>();
        Iterator metricsIt = root.get("Metrics").getElements();
        while (metricsIt.hasNext()) {
            JsonNode metricNode = (JsonNode)metricsIt.next();
            String measure = metricNode.get("Measure").asText();
            String metric = metricNode.get("Metric").asText();
            String value = metricNode.get("Value").asText();
            metricMap.put(measure + ":" + metric, value);
        }
        return metricMap;
    }

    private void assertFailedResponse(HealthServlet healthServlet) throws Exception {
        MockHttpServletResponse response = this.initAndExecuteDetailedCheck(healthServlet);
        Assert.assertEquals((String)"Response code should be 503", (long)503L, (long)response.getStatus());
        JsonNode root = this.parseContent(response.getContentAsString());
        Assert.assertEquals((Object)"Failed", (Object)root.get("Status").asText());
        Assert.assertTrue((boolean)root.has("Message"));
        Assert.assertFalse((boolean)StringUtils.isBlank((String)root.get("Message").asText()));
    }

    private boolean containsKeyStartsWith(String keyPrefix, Map<String, String> map) {
        for (String name : map.keySet()) {
            if (!name.startsWith(keyPrefix)) continue;
            return true;
        }
        return false;
    }
}

