/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.io.InputStream;
import java.util.Optional;
import org.mule.extension.file.common.api.AbstractFileInputStreamSupplier;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.connection.ConnectionSource;
import org.mule.extension.file.common.api.connection.ManagerBasedConnectionSource;
import org.mule.extension.file.common.api.connection.StaticConnectionSource;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectedFileInputStreamSupplier<T extends FileSystem>
extends AbstractFileInputStreamSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConnectedFileInputStreamSupplier.class);
    private ConnectionSource<T> connectionSource;
    private boolean contentProvided = false;
    private boolean contentConnectionReleased = false;

    public AbstractConnectedFileInputStreamSupplier(FileAttributes attributes, Long timeBetweenSizeCheck, ConnectionSource<T> connectionSource) {
        super(attributes, timeBetweenSizeCheck);
        this.connectionSource = connectionSource;
    }

    public AbstractConnectedFileInputStreamSupplier(FileAttributes attributes, Long timeBetweenSizeCheck, T fileSystem) {
        this(attributes, timeBetweenSizeCheck, new StaticConnectionSource<T>(fileSystem));
    }

    public AbstractConnectedFileInputStreamSupplier(FileAttributes attributes, ConnectionManager connectionManager, Long timeBetweenSizeCheck, FileConnectorConfig config) {
        this(attributes, timeBetweenSizeCheck, (T)new ManagerBasedConnectionSource(config, connectionManager));
    }

    @Override
    protected final FileAttributes getUpdatedAttributes() {
        try {
            T fileSystem = this.connectionSource.getConnection();
            FileAttributes updatedFileAttributes = this.getUpdatedAttributes(fileSystem);
            this.releaseConnection();
            if (updatedFileAttributes == null) {
                LOGGER.error(String.format("Error reading file from path %s. It no longer exists at the time of reading.", this.attributes.getPath()));
            }
            return updatedFileAttributes;
        }
        catch (ConnectionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not obtain connection to fetch file " + this.attributes.getPath())), (Throwable)e);
        }
    }

    @Override
    protected final InputStream getContentInputStream() {
        try {
            InputStream content = this.getContentInputStream(this.connectionSource.getConnection());
            this.contentProvided = true;
            return content;
        }
        catch (MuleRuntimeException e) {
            if (this.fileWasDeleted(e)) {
                this.onFileDeleted((Exception)((Object)e));
            }
            throw e;
        }
        catch (ConnectionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not obtain connection to fetch file " + this.attributes.getPath())), (Throwable)e);
        }
    }

    public void releaseConnectionUsedForContentInputStream() {
        if (this.contentProvided && !this.contentConnectionReleased) {
            this.releaseConnection();
            this.contentConnectionReleased = true;
        }
    }

    private void releaseConnection() {
        this.connectionSource.releaseConnection();
    }

    public Optional<T> getConnectionUsedForContentInputStream() throws ConnectionException {
        return this.contentProvided && !this.contentConnectionReleased ? Optional.of(this.connectionSource.getConnection()) : Optional.empty();
    }

    protected abstract FileAttributes getUpdatedAttributes(T var1);

    protected abstract InputStream getContentInputStream(T var1);

    protected abstract boolean fileWasDeleted(MuleRuntimeException var1);
}

