/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.exceptions.DeletedFileWhileReadException;
import org.mule.extension.file.common.api.exceptions.FileBeingModifiedException;
import org.mule.extension.file.common.api.stream.ExceptionInputStream;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileInputStreamSupplier
implements Supplier<InputStream> {
    private static final AtomicBoolean alreadyLoggedWarning = new AtomicBoolean();
    private static final String WAIT_WARNING_MESSAGE = "With the purpouse of performing a size check on the file %s, this thread will sleep. The connector has no control of which type of thread the sleep will take place on, this can lead to running out of thread if the time for 'timeBetweenSizeCheck' is big or a lot of files are being read concurrently. This warning will only be shown once.";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileInputStreamSupplier.class);
    private static final String STARTING_WAIT_MESSAGE = "Starting wait to check if the file size of the file %s is stable.";
    protected static final String FILE_NO_LONGER_EXISTS_MESSAGE = "Error reading file from path %s. It no longer exists at the time of reading.";
    private static final int MAX_SIZE_CHECK_RETRIES = 2;
    protected FileAttributes attributes;
    private Long timeBetweenSizeCheck;

    protected AbstractFileInputStreamSupplier(FileAttributes attributes, Long timeBetweenSizeCheck) {
        this.attributes = attributes;
        this.timeBetweenSizeCheck = timeBetweenSizeCheck;
    }

    @Override
    public InputStream get() {
        FileAttributes updatedAttributes = null;
        if (this.timeBetweenSizeCheck != null && this.timeBetweenSizeCheck > 0L && (updatedAttributes = this.getUpdatedStableAttributes()) == null) {
            this.onFileDeleted();
        }
        try {
            return this.getContentInputStream();
        }
        catch (RuntimeException e) {
            return new ExceptionInputStream(e);
        }
    }

    private FileAttributes getUpdatedStableAttributes() {
        FileAttributes oldAttributes;
        FileAttributes updatedAttributes = this.attributes;
        int retries = 0;
        do {
            oldAttributes = updatedAttributes;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format(STARTING_WAIT_MESSAGE, this.attributes.getPath()));
                }
                if (alreadyLoggedWarning.compareAndSet(false, true)) {
                    LOGGER.warn(String.format(WAIT_WARNING_MESSAGE, this.attributes.getPath()));
                }
                Thread.sleep(this.timeBetweenSizeCheck);
            }
            catch (InterruptedException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Execution was interrupted while waiting to recheck file sizes"), (Throwable)e);
            }
        } while ((updatedAttributes = this.getUpdatedAttributes()) != null && updatedAttributes.getSize() != oldAttributes.getSize() && retries++ <= 2);
        if (retries > 2) {
            throw new FileBeingModifiedException(I18nMessageFactory.createStaticMessage((String)("File on path " + this.attributes.getPath() + " is still being written.")));
        }
        return updatedAttributes;
    }

    protected void onFileDeleted() {
        throw new DeletedFileWhileReadException(I18nMessageFactory.createStaticMessage((String)("File on path " + this.attributes.getPath() + " was read but does not exist anymore.")));
    }

    protected void onFileDeleted(Exception e) {
        throw new DeletedFileWhileReadException(I18nMessageFactory.createStaticMessage((String)("File on path " + this.attributes.getPath() + " was read but does not exist anymore.")), e);
    }

    protected abstract FileAttributes getUpdatedAttributes();

    protected abstract InputStream getContentInputStream();
}

