/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.command;

import java.net.URI;
import org.mule.extension.file.common.api.ExternalFileSystem;
import org.mule.extension.file.common.api.command.AbstractFileCommand;
import org.mule.extension.file.common.api.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalFileCommand<F extends ExternalFileSystem>
extends AbstractFileCommand<F, URI> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalFileCommand.class);

    protected ExternalFileCommand(F externalFileSystem) {
        super(externalFileSystem);
    }

    @Override
    protected String pathToString(URI uri) {
        return uri.getPath();
    }

    @Override
    protected URI getAbsolutePath(URI uri) {
        return uri;
    }

    @Override
    protected URI getParent(URI uri) {
        return UriUtils.trimLastFragment(uri);
    }

    @Override
    protected URI resolvePath(URI baseUri, String filePath) {
        return UriUtils.createUri(baseUri.getPath(), filePath);
    }
}

