/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.odftoolkit.odfdom.changes.TextSelection;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;

public class TextHyperlinkSelection
extends TextSelection
implements Comparable {
    public TextHyperlinkSelection(TextAElement anchorElement, List<Integer> startPosition) {
        this.mUrl = anchorElement.getXlinkHrefAttribute();
        this.mSelectionElement = anchorElement;
        this.mStartPosition = startPosition;
    }

    public TextHyperlinkSelection(TextAElement anchorElement, List<Integer> startPosition, List<Integer> endPosition) {
        this.mUrl = anchorElement.getXlinkHrefAttribute();
        this.mSelectionElement = anchorElement;
        this.mStartPosition = startPosition;
        this.mEndPosition = endPosition;
    }

    public TextAElement getAElement() {
        return (TextAElement)this.mSelectionElement;
    }

    public TextHyperlinkSelection getOverLappingHyperlinkSelection(TreeSet<TextSelection> set) {
        TextHyperlinkSelection anchor = null;
        Iterator<TextSelection> it = set.iterator();
        TextSelection currentSelection = null;
        while (it.hasNext()) {
            currentSelection = it.next();
            if (!(currentSelection.mSelectionElement instanceof TextAElement) || !TextSelection.overLapping(this, currentSelection)) continue;
            anchor = (TextHyperlinkSelection)currentSelection;
            break;
        }
        return anchor;
    }

    public String toString() {
        return this.mStartPosition.toString() + "-URL" + this.mUrl + "-" + this.mEndPosition.toString() + this.mSelectionElement.toString() + ((TextAElement)this.mSelectionElement).getAutomaticStyle().toString();
    }
}

