/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.json.JsonParser;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.protobuf.ProtoParser;
import org.openrewrite.quark.QuarkParser;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class ResourceParser {
    private static final Set<String> DEFAULT_IGNORED_DIRECTORIES = new HashSet<String>(Arrays.asList("build", "target", "out", ".gradle", ".idea", ".project", "node_modules", ".git", ".metadata", ".DS_Store"));
    private final Path baseDir;
    private final Log logger;
    private final Collection<PathMatcher> exclusions;
    private final int sizeThresholdMb;
    private final Collection<Path> excludedDirectories;

    public ResourceParser(Path baseDir, Log logger, Collection<String> exclusions, int sizeThresholdMb, Collection<Path> excludedDirectories) {
        this.baseDir = baseDir;
        this.logger = logger;
        this.exclusions = this.exclusionMatchers(baseDir, exclusions);
        this.sizeThresholdMb = sizeThresholdMb;
        this.excludedDirectories = excludedDirectories;
    }

    private Collection<PathMatcher> exclusionMatchers(Path baseDir, Collection<String> exclusions) {
        return exclusions.stream().map(o -> baseDir.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList());
    }

    public List<SourceFile> parse(Path searchDir, Collection<Path> alreadyParsed) {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        if (!searchDir.toFile().exists()) {
            return sourceFiles;
        }
        Consumer<Throwable> errorConsumer = t -> this.logger.error((CharSequence)"Error parsing", t);
        InMemoryExecutionContext ctx = new InMemoryExecutionContext(errorConsumer);
        try {
            sourceFiles.addAll(this.parseSourceFiles(searchDir, alreadyParsed, (ExecutionContext)ctx));
        }
        catch (IOException e) {
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
            throw new UncheckedIOException(e);
        }
        return sourceFiles;
    }

    public <S extends SourceFile> List<S> parseSourceFiles(final Path searchDir, final Collection<Path> alreadyParsed, ExecutionContext ctx) throws IOException {
        final ArrayList resources = new ArrayList();
        final ArrayList quarkPaths = new ArrayList();
        final ArrayList plainTextPaths = new ArrayList();
        Files.walkFileTree(searchDir, Collections.emptySet(), 16, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (ResourceParser.this.isExcluded(dir) || ResourceParser.this.isIgnoredDirectory(searchDir, dir) || ResourceParser.this.excludedDirectories.contains(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!(attrs.isOther() || attrs.isSymbolicLink() || alreadyParsed.contains(file) || ResourceParser.this.isExcluded(file))) {
                    if (ResourceParser.this.isOverSizeThreshold(attrs.size())) {
                        ResourceParser.this.logger.info((CharSequence)("Parsing as quark " + file + " as its size + " + attrs.size() / 0x100000L + "Mb exceeds size threshold " + ResourceParser.this.sizeThresholdMb + "Mb"));
                        quarkPaths.add(file);
                    } else if (ResourceParser.this.isParsedAsPlainText(file)) {
                        plainTextPaths.add(file);
                    } else {
                        resources.add(file);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        ArrayList sourceFiles = new ArrayList(resources.size() + quarkPaths.size());
        JsonParser jsonParser = new JsonParser();
        ArrayList jsonPaths = new ArrayList();
        XmlParser xmlParser = new XmlParser();
        ArrayList xmlPaths = new ArrayList();
        YamlParser yamlParser = new YamlParser();
        ArrayList yamlPaths = new ArrayList();
        PropertiesParser propertiesParser = new PropertiesParser();
        ArrayList propertiesPaths = new ArrayList();
        ProtoParser protoParser = new ProtoParser();
        ArrayList protoPaths = new ArrayList();
        HclParser hclParser = HclParser.builder().build();
        ArrayList hclPaths = new ArrayList();
        PlainTextParser plainTextParser = new PlainTextParser();
        QuarkParser quarkParser = new QuarkParser();
        resources.forEach(path -> {
            if (jsonParser.accept(path)) {
                jsonPaths.add(path);
            } else if (xmlParser.accept(path)) {
                xmlPaths.add(path);
            } else if (yamlParser.accept(path)) {
                yamlPaths.add(path);
            } else if (propertiesParser.accept(path)) {
                propertiesPaths.add(path);
            } else if (protoParser.accept(path)) {
                protoPaths.add(path);
            } else if (hclParser.accept(path)) {
                hclPaths.add(path);
            } else if (quarkParser.accept(path)) {
                quarkPaths.add(path);
            }
        });
        sourceFiles.addAll(jsonParser.parse(jsonPaths, this.baseDir, ctx));
        alreadyParsed.addAll(jsonPaths);
        sourceFiles.addAll(xmlParser.parse(xmlPaths, this.baseDir, ctx));
        alreadyParsed.addAll(xmlPaths);
        sourceFiles.addAll(yamlParser.parse(yamlPaths, this.baseDir, ctx));
        alreadyParsed.addAll(yamlPaths);
        sourceFiles.addAll(propertiesParser.parse(propertiesPaths, this.baseDir, ctx));
        alreadyParsed.addAll(propertiesPaths);
        sourceFiles.addAll(protoParser.parse(protoPaths, this.baseDir, ctx));
        alreadyParsed.addAll(protoPaths);
        sourceFiles.addAll(hclParser.parse(hclPaths, this.baseDir, ctx));
        alreadyParsed.addAll(hclPaths);
        sourceFiles.addAll(plainTextParser.parse(plainTextPaths, this.baseDir, ctx));
        alreadyParsed.addAll(plainTextPaths);
        sourceFiles.addAll(quarkParser.parse(quarkPaths, this.baseDir, ctx));
        alreadyParsed.addAll(quarkPaths);
        return sourceFiles;
    }

    private boolean isOverSizeThreshold(long fileSize) {
        return this.sizeThresholdMb > 0 && fileSize > (long)this.sizeThresholdMb * 1024L * 1024L;
    }

    private boolean isExcluded(Path path) {
        for (PathMatcher excluded : this.exclusions) {
            if (!excluded.matches(this.baseDir.relativize(path))) continue;
            return true;
        }
        return false;
    }

    private boolean isParsedAsPlainText(Path path) {
        String pathString = path.toString();
        return pathString.contains("/META-INF/services") || pathString.endsWith(".gitignore") || pathString.endsWith(".gitattributes") || pathString.endsWith(".java-version") || pathString.endsWith(".sdkmanrc");
    }

    private boolean isIgnoredDirectory(Path searchDir, Path path) {
        for (Path pathSegment : searchDir.relativize(path)) {
            if (!DEFAULT_IGNORED_DIRECTORIES.contains(pathSegment.toString())) continue;
            return true;
        }
        return false;
    }
}

