/**
 * CAROL Interceptors
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: BasicServiceContext.java 1880 2008-06-28 21:10:49Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.carol.rmi.interceptor.impl;

import java.io.Serializable;

import org.ow2.carol.rmi.interceptor.spi.JServiceContext;

/**
 * A service context that wraps serializable data.
 * @author Loris Bouzonnet
 */
public class BasicServiceContext<Data extends Serializable> implements JServiceContext {

	/**
	 * Id for serializable class.
	 */
	private static final long serialVersionUID = 6634144210044754330L;

	/**
	 * Context id.
	 */
	private final int id;

	/**
	 * Piggy-backed data.
	 */
	private final Data data;

	public BasicServiceContext(final int id, final Data data) {
		this.id = id;
		this.data = data;
	}

	/**
	 * @return the piggy-backed data
	 */
	public Data getContextData() {
		return data;
	}

	public int getContextId() {
		return id;
	}

}
