/**
 * Copyright (C) 2002-2007 - INRIA (www.inria.fr)
 *
 * CAROL: Common Architecture for RMI ObjectWeb Layer
 *
 * This library is developed inside the OW2 Consortium,
 * http://www.ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JInitializer.java 1846 2008-06-11 11:59:13Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.carol.rmi.interceptor.spi;

import org.ow2.carol.rmi.interceptor.api.JInitInfo;


/**
 * Interface <code>JInitializer</code> is the CAROL JRMP Initializer interface
 * This interface is used to register Interceptor
 * @author Guillaume Riviere (Guillaume.Riviere@inrialpes.fr)
 * @version 1.0, 15/07/2002
 */
public interface JInitializer {

    /**
     * In JRMP the 2 methods (pre and post init) have the same consequences...
     * @param JInitInfo the JInit Information
     */
    public void preInit(JInitInfo info);

    /**
     * In JRMP the 2 methods (pre and post init) have the same consequences...
     * @param JInitInfo the JInit Information
     */
    public void postInit(JInitInfo info);

}