/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import java.util.ArrayList;
import java.util.Collection;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.MutationResult;

public class ClassMutationResults {
    private final Collection<MutationResult> mutations = new ArrayList<MutationResult>();

    public ClassMutationResults(Collection<MutationResult> mutations) {
        this.mutations.addAll(mutations);
    }

    public String getFileName() {
        return this.mutations.iterator().next().getDetails().getFilename();
    }

    public Collection<MutationResult> getMutations() {
        return this.mutations;
    }

    public ClassName getMutatedClass() {
        return this.mutations.iterator().next().getDetails().getClassName();
    }

    public String getPackageName() {
        ClassName name = this.getMutatedClass();
        int lastDot = name.asJavaName().lastIndexOf(46);
        return lastDot > 0 ? name.asJavaName().substring(0, lastDot) : "default";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mutations == null ? 0 : this.mutations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMutationResults other = (ClassMutationResults)obj;
        return !(this.mutations == null ? other.mutations != null : !this.mutations.equals(other.mutations));
    }

    public String toString() {
        return "ClassMutationResults [mutations=" + this.mutations + "]";
    }
}

