/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.log.BaseLogEntry;
import org.openqa.selenium.bidi.log.ConsoleLogEntry;
import org.openqa.selenium.bidi.log.FilterBy;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.JavascriptLogEntry;
import org.openqa.selenium.bidi.log.Log;
import org.openqa.selenium.bidi.log.LogEntry;
import org.openqa.selenium.bidi.log.LogLevel;
import org.openqa.selenium.internal.Require;

public class LogInspector
implements AutoCloseable {
    private final Set<String> browsingContextIds;
    private final BiDi bidi;

    public LogInspector(WebDriver driver) {
        this(new HashSet<String>(), driver);
    }

    public LogInspector(String browsingContextId, WebDriver driver) {
        this(Collections.singleton((String)Require.nonNull((String)"Browsing context id", (Object)browsingContextId)), driver);
    }

    public LogInspector(Set<String> browsingContextIds, WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing context id list", browsingContextIds);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.browsingContextIds = browsingContextIds;
    }

    @Deprecated
    public void onConsoleLog(Consumer<ConsoleLogEntry> consumer) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getConsoleLogEntry().ifPresent(consumer);
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onConsoleEntry(Consumer<ConsoleLogEntry> consumer) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getConsoleLogEntry().ifPresent(consumer);
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onConsoleEntry(Consumer<ConsoleLogEntry> consumer, FilterBy filter) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getConsoleLogEntry().ifPresent(entry -> {
            if (filter.getLevel() != null && entry.getLevel() == filter.getLevel()) {
                consumer.accept((ConsoleLogEntry)entry);
            }
        });
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onJavaScriptLog(Consumer<JavascriptLogEntry> consumer) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getJavascriptLogEntry().ifPresent(consumer);
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onJavaScriptLog(Consumer<JavascriptLogEntry> consumer, FilterBy filter) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getJavascriptLogEntry().ifPresent(entry -> {
            if (filter.getLevel() != null && entry.getLevel() == filter.getLevel()) {
                consumer.accept((JavascriptLogEntry)entry);
            }
        });
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onJavaScriptException(Consumer<JavascriptLogEntry> consumer) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getJavascriptLogEntry().ifPresent(entry -> {
            if (entry.getLevel() == LogLevel.ERROR) {
                consumer.accept((JavascriptLogEntry)entry);
            }
        });
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onGenericLog(Consumer<GenericLogEntry> consumer) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getGenericLogEntry().ifPresent(consumer);
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onGenericLog(Consumer<GenericLogEntry> consumer, FilterBy filter) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> logEntry.getGenericLogEntry().ifPresent(entry -> {
            if (filter.getLevel() != null && entry.getLevel() == filter.getLevel()) {
                consumer.accept((GenericLogEntry)entry);
            }
        });
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    public void onLog(Consumer<LogEntry> consumer) {
        this.addLogEntryAddedListener(consumer);
    }

    public void onLog(Consumer<LogEntry> consumer, FilterBy filter) {
        Consumer<LogEntry> logEntryConsumer = logEntry -> {
            AtomicReference baseLogEntry = new AtomicReference();
            logEntry.getGenericLogEntry().ifPresent(baseLogEntry::set);
            logEntry.getConsoleLogEntry().ifPresent(baseLogEntry::set);
            logEntry.getJavascriptLogEntry().ifPresent(baseLogEntry::set);
            if (filter.getLevel() != null && ((BaseLogEntry)baseLogEntry.get()).getLevel() == filter.getLevel()) {
                consumer.accept((LogEntry)logEntry);
            }
        };
        this.addLogEntryAddedListener(logEntryConsumer);
    }

    private void addLogEntryAddedListener(Consumer<LogEntry> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(Log.entryAdded(), consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, Log.entryAdded(), consumer);
        }
    }

    @Override
    public void close() {
        this.bidi.clearListener(Log.entryAdded());
    }
}

