/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import org.openqa.selenium.remote.PropertyMunger;
import org.openqa.selenium.remote.server.HttpRequest;
import org.openqa.selenium.remote.server.HttpResponse;
import org.openqa.selenium.remote.server.rest.Renderer;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class RedirectResult
implements Renderer {
    private final String url;

    public RedirectResult(String url) {
        this.url = url;
    }

    @Override
    public void render(HttpRequest request, HttpResponse response, RestishHandler handler) throws Exception {
        String[] urlParts;
        StringBuilder builder = new StringBuilder(request.getAppUri());
        for (String part : urlParts = this.url.split("/")) {
            if (part.length() == 0) continue;
            builder.append("/");
            if (part.startsWith(":")) {
                builder.append(this.get(handler, part));
                continue;
            }
            builder.append(part);
        }
        response.sendRedirect(builder.toString());
    }

    private String get(RestishHandler handler, String part) throws Exception {
        if (part.length() < 1) {
            return "";
        }
        String propertyName = part.substring(1);
        Object value = PropertyMunger.get((String)propertyName, (Object)handler);
        return value == null ? "" : String.valueOf(value);
    }
}

