/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

class ImportsContextCustomizer
implements ContextCustomizer {
    static final String TEST_CLASS_ATTRIBUTE = "testClass";
    private final Class<?> testClass;
    private final ContextCustomizerKey key;

    ImportsContextCustomizer(Class<?> testClass) {
        this.testClass = testClass;
        this.key = new ContextCustomizerKey(testClass);
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        BeanDefinitionRegistry registry = this.getBeanDefinitionRegistry((ApplicationContext)context);
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        this.registerCleanupPostProcessor(registry, reader);
        this.registerImportsConfiguration(registry, reader);
    }

    private void registerCleanupPostProcessor(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader) {
        BeanDefinition definition = this.registerBean(registry, reader, ImportsCleanupPostProcessor.BEAN_NAME, ImportsCleanupPostProcessor.class);
        definition.getConstructorArgumentValues().addIndexedArgumentValue(0, this.testClass);
    }

    private void registerImportsConfiguration(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader) {
        BeanDefinition definition = this.registerBean(registry, reader, ImportsConfiguration.BEAN_NAME, ImportsConfiguration.class);
        definition.setAttribute(TEST_CLASS_ATTRIBUTE, this.testClass);
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        if (context instanceof AbstractApplicationContext) {
            return (BeanDefinitionRegistry)((AbstractApplicationContext)context).getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    private BeanDefinition registerBean(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader, String beanName, Class<?> type) {
        reader.registerBean(type, beanName, new Class[0]);
        BeanDefinition definition = registry.getBeanDefinition(beanName);
        return definition;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImportsContextCustomizer other = (ImportsContextCustomizer)obj;
        return this.key.equals(other.key);
    }

    private static final class SpockAnnotationFilter
    implements AnnotationFilter {
        private SpockAnnotationFilter() {
        }

        @Override
        public boolean isIgnored(Annotation annotation) {
            return annotation.annotationType().getName().startsWith("org.spockframework.");
        }
    }

    private static final class KotlinAnnotationFilter
    implements AnnotationFilter {
        private KotlinAnnotationFilter() {
        }

        @Override
        public boolean isIgnored(Annotation annotation) {
            return "kotlin.Metadata".equals(annotation.annotationType().getName()) || this.isInKotlinAnnotationPackage(annotation);
        }

        private boolean isInKotlinAnnotationPackage(Annotation annotation) {
            return annotation.annotationType().getName().startsWith("kotlin.annotation.");
        }
    }

    private static final class JavaLangAnnotationFilter
    implements AnnotationFilter {
        private JavaLangAnnotationFilter() {
        }

        @Override
        public boolean isIgnored(Annotation annotation) {
            return AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)annotation);
        }
    }

    private static interface AnnotationFilter {
        public boolean isIgnored(Annotation var1);
    }

    static class ContextCustomizerKey {
        private static final Set<AnnotationFilter> ANNOTATION_FILTERS;
        private final Set<Annotation> annotations;

        ContextCustomizerKey(Class<?> testClass) {
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            HashSet seen = new HashSet();
            this.collectClassAnnotations(testClass, annotations, seen);
            this.annotations = Collections.unmodifiableSet(annotations);
        }

        private void collectClassAnnotations(Class<?> classType, Set<Annotation> annotations, Set<Class<?>> seen) {
            if (seen.add(classType)) {
                this.collectElementAnnotations(classType, annotations, seen);
                for (Class<?> interfaceType : classType.getInterfaces()) {
                    this.collectClassAnnotations(interfaceType, annotations, seen);
                }
                if (classType.getSuperclass() != null) {
                    this.collectClassAnnotations(classType.getSuperclass(), annotations, seen);
                }
            }
        }

        private void collectElementAnnotations(AnnotatedElement element, Set<Annotation> annotations, Set<Class<?>> seen) {
            for (Annotation annotation : element.getDeclaredAnnotations()) {
                if (this.isIgnoredAnnotation(annotation)) continue;
                annotations.add(annotation);
                this.collectClassAnnotations(annotation.annotationType(), annotations, seen);
            }
        }

        private boolean isIgnoredAnnotation(Annotation annotation) {
            for (AnnotationFilter annotationFilter : ANNOTATION_FILTERS) {
                if (!annotationFilter.isIgnored(annotation)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.annotations.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && this.annotations.equals(((ContextCustomizerKey)obj).annotations);
        }

        static {
            HashSet<AnnotationFilter> filters = new HashSet<AnnotationFilter>();
            filters.add(new JavaLangAnnotationFilter());
            filters.add(new KotlinAnnotationFilter());
            filters.add(new SpockAnnotationFilter());
            ANNOTATION_FILTERS = Collections.unmodifiableSet(filters);
        }
    }

    @Order(value=0x7FFFFFFF)
    static class ImportsCleanupPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        static final String BEAN_NAME = ImportsCleanupPostProcessor.class.getName();
        private final Class<?> testClass;

        ImportsCleanupPostProcessor(Class<?> testClass) {
            this.testClass = testClass;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            try {
                String[] names;
                for (String name : names = registry.getBeanDefinitionNames()) {
                    BeanDefinition definition = registry.getBeanDefinition(name);
                    if (!this.testClass.getName().equals(definition.getBeanClassName())) continue;
                    registry.removeBeanDefinition(name);
                }
                registry.removeBeanDefinition(ImportsConfiguration.BEAN_NAME);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    static class ImportsSelector
    implements ImportSelector,
    BeanFactoryAware {
        private static final String[] NO_IMPORTS = new String[0];
        private ConfigurableListableBeanFactory beanFactory;

        ImportsSelector() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            String[] stringArray;
            Object testClass;
            BeanDefinition definition = this.beanFactory.getBeanDefinition(ImportsConfiguration.BEAN_NAME);
            Object object = testClass = definition == null ? null : definition.getAttribute(ImportsContextCustomizer.TEST_CLASS_ATTRIBUTE);
            if (testClass == null) {
                stringArray = NO_IMPORTS;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ((Class)testClass).getName();
            }
            return stringArray;
        }
    }

    @Configuration
    @Import(value={ImportsSelector.class})
    static class ImportsConfiguration {
        static final String BEAN_NAME = ImportsConfiguration.class.getName();

        ImportsConfiguration() {
        }
    }
}

