/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import java.util.List;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceScanCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceClusterKeyCommands
extends LettuceKeyCommands {
    private final LettuceClusterConnection connection;

    LettuceClusterKeyCommands(LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public void rename(byte[] oldKey, byte[] newKey) {
        Assert.notNull((Object)oldKey, (String)"Old key must not be null");
        Assert.notNull((Object)newKey, (String)"New key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(oldKey, newKey)) {
            super.rename(oldKey, newKey);
            return;
        }
        byte[] value = this.dump(oldKey);
        if (value != null && value.length > 0) {
            this.restore(newKey, 0L, value, true);
            this.del(new byte[][]{oldKey});
        }
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sourceKey, targetKey)) {
            return super.renameNX(sourceKey, targetKey);
        }
        byte[] value = this.dump(sourceKey);
        if (value != null && value.length > 0 && !this.exists(targetKey).booleanValue()) {
            this.restore(targetKey, 0L, value);
            this.del(new byte[][]{sourceKey});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        throw new InvalidDataAccessApiUsageException("MOVE not supported in CLUSTER mode");
    }

    @Nullable
    public byte[] randomKey(RedisClusterNode node) {
        return (byte[])this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> (byte[])client.randomkey(), node).getValue();
    }

    @Nullable
    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        return LettuceConverters.toBytesSet((List)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> client.keys((Object)pattern), node).getValue());
    }

    Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        Assert.notNull((Object)node, (String)"RedisClusterNode must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        return (Cursor)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> new LettuceScanCursor<byte[]>(options){

            @Override
            protected LettuceScanCursor.LettuceScanIteration<byte[]> doScan(ScanCursor cursor, ScanOptions options) {
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                KeyScanCursor keyScanCursor = client.scan(cursor, scanArgs);
                return new LettuceScanCursor.LettuceScanIteration<byte[]>((ScanCursor)keyScanCursor, keyScanCursor.getKeys());
            }
        }.open(), node).getValue();
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(key, storeKey)) {
            return super.sort(key, params, storeKey);
        }
        List<byte[]> sorted = this.sort(key, params);
        byte[][] arr = new byte[sorted.size()][];
        this.connection.keyCommands().unlink(new byte[][]{storeKey});
        this.connection.listCommands().lPush(storeKey, (byte[][])sorted.toArray((T[])arr));
        return sorted.size();
    }
}

