/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.TlsContext;

public class X509CredentialsProvider
extends CredentialsProvider {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private X509CredentialsProvider(X509CredentialsProviderBuilder builder) {
        String thingName = builder.getThingName();
        String roleAlias = builder.getRoleAlias();
        String endpoint = builder.getEndpoint();
        if (thingName == null || roleAlias == null || endpoint == null) {
            throw new IllegalArgumentException("X509CredentialsProvider - thingName, roleAlias, and endpoint must be non null");
        }
        ClientBootstrap clientBootstrap = builder.getClientBootstrap();
        if (clientBootstrap == null) {
            clientBootstrap = ClientBootstrap.getOrCreateStaticDefault();
        }
        TlsContext tlsContext = builder.getTlsContext();
        if (clientBootstrap == null || tlsContext == null) {
            throw new IllegalArgumentException("X509CredentialsProvider - clientBootstrap and tlsContext must be non null");
        }
        int proxyConnectionType = 0;
        long proxyTlsContextHandle = 0L;
        String proxyHost = null;
        int proxyPort = 0;
        int proxyAuthorizationType = 0;
        String proxyAuthorizationUsername = null;
        String proxyAuthorizationPassword = null;
        String noProxyHosts = null;
        HttpProxyOptions proxyOptions = builder.getProxyOptions();
        if (proxyOptions != null) {
            proxyConnectionType = proxyOptions.getConnectionType().getValue();
            TlsContext proxyTlsContext = proxyOptions.getTlsContext();
            if (proxyTlsContext != null) {
                proxyTlsContextHandle = proxyTlsContext.getNativeHandle();
            }
            proxyHost = proxyOptions.getHost();
            proxyPort = proxyOptions.getPort();
            proxyAuthorizationType = proxyOptions.getAuthorizationType().getValue();
            proxyAuthorizationUsername = proxyOptions.getAuthorizationUsername();
            proxyAuthorizationPassword = proxyOptions.getAuthorizationPassword();
            noProxyHosts = proxyOptions.getNoProxyHosts();
        }
        long nativeHandle = X509CredentialsProvider.x509CredentialsProviderNew(this, clientBootstrap.getNativeHandle(), tlsContext.getNativeHandle(), thingName.getBytes(UTF8), roleAlias.getBytes(UTF8), endpoint.getBytes(UTF8), proxyConnectionType, proxyHost != null ? proxyHost.getBytes(UTF8) : null, proxyPort, proxyTlsContextHandle, proxyAuthorizationType, proxyAuthorizationUsername != null ? proxyAuthorizationUsername.getBytes(UTF8) : null, proxyAuthorizationPassword != null ? proxyAuthorizationPassword.getBytes(UTF8) : null, noProxyHosts != null ? noProxyHosts.getBytes(UTF8) : null);
        this.acquireNativeHandle(nativeHandle);
        this.addReferenceTo(clientBootstrap);
        this.addReferenceTo(tlsContext);
    }

    private static native long x509CredentialsProviderNew(X509CredentialsProvider var0, long var1, long var3, byte[] var5, byte[] var6, byte[] var7, int var8, byte[] var9, int var10, long var11, int var13, byte[] var14, byte[] var15, byte[] var16);

    public static class X509CredentialsProviderBuilder {
        private String thingName;
        private String roleAlias;
        private String endpoint;
        private TlsContext tlsContext;
        private ClientBootstrap clientBootstrap;
        private HttpProxyOptions proxyOptions;

        public X509CredentialsProviderBuilder withClientBootstrap(ClientBootstrap clientBootstrap) {
            this.clientBootstrap = clientBootstrap;
            return this;
        }

        ClientBootstrap getClientBootstrap() {
            return this.clientBootstrap;
        }

        public X509CredentialsProviderBuilder withTlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        TlsContext getTlsContext() {
            return this.tlsContext;
        }

        public X509CredentialsProviderBuilder withThingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        String getThingName() {
            return this.thingName;
        }

        public X509CredentialsProviderBuilder withRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        String getRoleAlias() {
            return this.roleAlias;
        }

        public X509CredentialsProviderBuilder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        String getEndpoint() {
            return this.endpoint;
        }

        public X509CredentialsProviderBuilder withProxyOptions(HttpProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        HttpProxyOptions getProxyOptions() {
            return this.proxyOptions;
        }

        public X509CredentialsProvider build() {
            return new X509CredentialsProvider(this);
        }
    }
}

