---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


declare
  l_max_value number;
begin

  select max(question_id) into l_max_value from question;

  execute immediate 'drop sequence SEQ_QUESTION_ID';
  execute immediate 'CREATE SEQUENCE SEQ_QUESTION_ID START WITH ' || l_max_value || ' INCREMENT BY 1 NOMAXVALUE NOCYCLE NOCACHE ORDER';

end;
/

ALTER TABLE QUESTION
  ADD CONSTRAINT UC1_QUESTION UNIQUE (QUESTION_ID, SEQUENCE_NUMBER);

ALTER TABLE QUESTION
  ADD CONSTRAINT UC2_QUESTION UNIQUE (OBJ_ID);

ALTER TABLE QUESTION
  ADD CONSTRAINT FK_QUESTION_TYPE
FOREIGN KEY (QUESTION_TYPE_ID) REFERENCES question_types(QUESTION_TYPE_ID);

ALTER TABLE question_explanation
  ADD CONSTRAINT UC1_question_explan UNIQUE (OBJ_ID);

ALTER TABLE question_multi_choice
  ADD CONSTRAINT UC1_question_mc UNIQUE (OBJ_ID);

ALTER TABLE question_types
  ADD CONSTRAINT UC1_question_types UNIQUE (OBJ_ID);

ALTER TABLE questionnaire
  ADD CONSTRAINT UC2_questionnaire UNIQUE (OBJ_ID);

ALTER TABLE questionnaire_answer
  ADD CONSTRAINT UC1_questionnaire_answer UNIQUE (OBJ_ID);

ALTER TABLE questionnaire_answer_header
  ADD CONSTRAINT UC1_questionnaire_ah UNIQUE (OBJ_ID);

ALTER TABLE questionnaire_condition_type
  ADD CONSTRAINT UC1_questionnaire_cond_type UNIQUE (OBJ_ID);

ALTER TABLE questionnaire_questions
  ADD CONSTRAINT UC1_questionnaire_questions UNIQUE (OBJ_ID);

ALTER TABLE questionnaire_usage
  ADD CONSTRAINT UC1_questionnaire_usage UNIQUE (OBJ_ID);
