---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE SEQUENCE SEQ_S2S_OVERRIDE_APPL_DATA_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE S2S_OVERRIDE_APPL_DATA (
  ID VARCHAR2(25) NOT NULL,
  FILE_NAME VARCHAR2(100),
  APPLICATION CLOB,
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL
);

ALTER TABLE S2S_OVERRIDE_APPL_DATA
  ADD CONSTRAINT PK_S2S_OVERRIDE_APPL_DATA
PRIMARY KEY (ID);

ALTER TABLE S2S_OVERRIDE_APPL_DATA
  ADD CONSTRAINT UQ_S2S_OVERRIDE_APPL_DATA
UNIQUE (OBJ_ID);


CREATE SEQUENCE SEQ_S2S_OVERRIDE_ATT_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE S2S_OVERRIDE_ATT (
  ID VARCHAR2(25) NOT NULL,
  S2S_OVERRIDE_APPL_DATA_ID VARCHAR2(25) NOT NULL,
  CONTENT_ID VARCHAR2(300) NOT NULL,
  FILE_NAME VARCHAR2(100) NOT NULL,
  CONTENT_TYPE VARCHAR2(100) NOT NULL,
  FILE_DATA_ID VARCHAR2(36) NOT NULL,
  UPLOAD_TIMESTAMP DATE NOT NULL,
  UPLOAD_USER VARCHAR2(60) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL
);

ALTER TABLE S2S_OVERRIDE_ATT
  ADD CONSTRAINT PK_S2S_OVERRIDE_ATT
PRIMARY KEY (ID);

ALTER TABLE S2S_OVERRIDE_ATT
  ADD CONSTRAINT UQ_S2S_OVERRIDE_ATT
UNIQUE (OBJ_ID);

ALTER TABLE S2S_OVERRIDE_ATT
  ADD CONSTRAINT FK_DATA_S2S_OVERRIDE_ATT
FOREIGN KEY (S2S_OVERRIDE_APPL_DATA_ID) REFERENCES S2S_OVERRIDE_APPL_DATA (ID);

ALTER TABLE S2S_OVERRIDE_ATT
  ADD CONSTRAINT FK_FILE_DATA_S2S_OVERRIDE_ATT
FOREIGN KEY (FILE_DATA_ID) REFERENCES FILE_DATA (ID);



CREATE SEQUENCE SEQ_S2S_OVERRIDE_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE S2S_OVERRIDE (
  ID VARCHAR2(25) NOT NULL,
  PROPOSAL_NUMBER VARCHAR2(12) NOT NULL,
  S2S_APPL_DATA_ID VARCHAR2(25),
  S2S_APPL_DATA_OVERRIDE_ID VARCHAR2(25),
  DESCRIPTION VARCHAR2(200),
  ACTIVE CHAR(1) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL
);

ALTER TABLE S2S_OVERRIDE
  ADD CONSTRAINT PK_S2S_OVERRIDE
PRIMARY KEY (ID);

ALTER TABLE S2S_OVERRIDE
  ADD CONSTRAINT UQ_S2S_OVERRIDE
UNIQUE (OBJ_ID);

ALTER TABLE S2S_OVERRIDE
  ADD CONSTRAINT FK_PD_S2S_OVERRIDE
FOREIGN KEY (PROPOSAL_NUMBER) REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE S2S_OVERRIDE
  ADD CONSTRAINT FK_AD_S2S_OVERRIDE
FOREIGN KEY (S2S_APPL_DATA_ID) REFERENCES S2S_OVERRIDE_APPL_DATA (ID);

ALTER TABLE S2S_OVERRIDE
  ADD CONSTRAINT FK_ADO_S2S_OVERRIDE
FOREIGN KEY (S2S_APPL_DATA_OVERRIDE_ID) REFERENCES S2S_OVERRIDE_APPL_DATA (ID);

ALTER TABLE S2S_OVERRIDE
  ADD CONSTRAINT UQ_S2S_OVERRIDE2
UNIQUE (PROPOSAL_NUMBER);
