---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE, QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, -10145, 1, 'C', 'Does the proposed project involve human fetal tissue obtained from elective abortions?', 'A', 4, 1, null, null, null, null, 1, sysdate, 'admin', 1, sys_guid());

INSERT INTO QUESTIONNAIRE (QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, IS_FINAL, VER_NBR, OBJ_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, -7, 1, 'PHS 398 Cover Page Supplement v5-0', 'The responses are used to populate the PHS 398 Cover Page Supplement v5-0 for submission via Grants.gov.', sysdate, 'admin', 'Y', 1, sys_guid());

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=145 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 145)),
        3, 0, 1, 'N', null, null, 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=146 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 146)),
        4, 3, 1, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=147 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 147)),
        5, 4, 1, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=148 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 148)),
        6, 5, 1, 'Y', 4, 'N', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=5 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 5)),
        7, 0, 2, 'N', null, null, 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=6 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 6)),
        8, 7, 1, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=149 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 149)),
        9, 8, 2, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=118 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 118)),
        10, 0, 3, 'N', null, null, 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=119 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 119)),
        11, 10, 1, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=120 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 120)),
        12, 11, 1, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=114 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 114)),
        13, 0, 4, 'N', null, null, 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=115 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 115)),
        14, 13, 1, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=116 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 116)),
        15, 0, 5, 'N', null, null, 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=117 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 117)),
        16, 15, 1, 'Y', 4, 'Y', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10145 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10145)),
        17, 0, 1, 'N', null, null, 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID, MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE, QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER, RULE_ID, QUESTIONNAIRE_LABEL, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, IS_MANDATORY)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 3, 2, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -7 AND SEQUENCE_NUMBER = 1), 1, null,'PHS 398 Cover Page Supplement v4-0', sysdate, 'admin', 1, sys_guid(), 'N');

INSERT INTO S2S_FORM_TO_QUESTIONNAIRE (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 'http://apply.grants.gov/forms/PHS398_CoverPageSupplement_5_0-V5.0', 'PHS398_CoverPageSupplement_5_0-V5.0', -7, sysdate, 'admin', sys_guid(), 1);


INSERT INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES('-5' ,'HFT_ComplianceAssurance', 'P', 'N', 'N', 'admin', sysdate, sys_guid(), 1);

INSERT INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES('-6' ,'HFT_SampleIRB_ConsentForm', 'P', 'N', 'N', 'admin', sysdate, sys_guid(), 1);

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'PHS398_CoverPageSupplement_5_0-V5.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'HFT_ComplianceAssurance'), 'N', 'admin', sysdate, sys_guid());

INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'PHS398_CoverPageSupplement_5_0-V5.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'HFT_SampleIRB_ConsentForm'), 'N', 'admin', sysdate, sys_guid());


INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/PHS398_CoverPageSupplement_5_0/StemCells', 'Please answer the human embryonic stem cells question.', 'questions', sysdate, 'admin', 1, sys_guid());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/PHS398_CoverPageSupplement_5_0/StemCells/CellLines', 'The registration number of the specific cell line is too long. Please see the human embryonic stem cells question for explanation.', 'questions', sysdate, 'admin', 1, sys_guid());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/PHS398_CoverPageSupplement_5_0/IsChangeOfPDPI', 'Please answer the change in PDPI question.', 'questions', sysdate, 'admin', 1, sys_guid());

INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/PHS398_CoverPageSupplement_5_0/IsChangeOfInstitution', 'Please answer the change grantee institution question.', 'questions', sysdate, 'admin', 1, sys_guid());
