---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE TABLE IACUC_PROTOCOL_SPECIES ( 
    IACUC_PROTOCOL_SPECIES_ID NUMBER(12,0) NOT NULL, 
    PROTOCOL_ID NUMBER(12,0) NOT NULL, 
    PROTOCOL_NUMBER VARCHAR2(20) NOT NULL, 
    SEQUENCE_NUMBER NUMBER(4,0) NOT NULL, 
    SPECIES_ID NUMBER(3,0) NOT NULL, 
    SPECIES_CODE NUMBER(4,0) NOT NULL, 
    SPECIES_GROUP VARCHAR2(50) NOT NULL, 
    IS_USDA_COVERED VARCHAR2(1) NOT NULL, 
    STRAIN VARCHAR2(30), 
    SPECIES_COUNT NUMBER(8,0), 
    PAIN_CATEGORY_CODE NUMBER(3,0), 
    SPECIES_COUNT_CODE NUMBER(3,0), 
    EXCEPTIONS_PRESENT VARCHAR2(1) DEFAULT 'N', 
    PROCEDURE_SUMMARY VARCHAR2(2000), 
    UPDATE_TIMESTAMP DATE NOT NULL, 
    UPDATE_USER VARCHAR2(60) NOT NULL, 
    VER_NBR NUMBER(8,0) DEFAULT 1 NOT NULL, 
    OBJ_ID VARCHAR2(36) NOT NULL) ;


ALTER TABLE IACUC_PROTOCOL_SPECIES 
ADD CONSTRAINT PK_IACUC_PROTOCOL_SPECIES 
PRIMARY KEY (IACUC_PROTOCOL_SPECIES_ID) ;

