---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


INSERT INTO SPONSOR_FORMS (SPONSOR_CODE, PACKAGE_NUMBER, PACKAGE_NAME, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, SPONSOR_FORM_ID) VALUES ('999999', '3', 'Local Printing Forms', SYSDATE, 'admin', '1', SYS_GUID(), '11');
commit;
INSERT INTO SPONSOR_FORM_TEMPLATES (SPONSOR_FORM_TEMPLATE_ID,SPONSOR_FORM_ID,PAGE_NUMBER,PAGE_DESCRIPTION,FILE_NAME,CONTENT_TYPE,FORM_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) values (SEQ_SPONSOR_FORM_TEMPLATES.NEXTVAL,(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3),1,'Proposal Development Summary Print','ProposalDevelopmentSummary.xslt','text/xml',EMPTY_CLOB(),'admin',SYSDATE,SYS_GUID(),1);
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:approvalRouting="http://v2.xml.utils.coeus.mit.edu/ApprovalRouting" xmlns:budget="http://v2.xml.utils.coeus.mit.edu/budget" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:lookuptypes="http://v2.xml.utils.coeus.mit.edu/lookuptypes" xmlns:modularbudget="http://v2.xml.utils.coeus.mit.edu/modularbudget" xmlns:organization="http://v2.xml.utils.coeus.mit.edu/organization" xmlns:propdev="http://v2.xml.utils.coeus.mit.edu/propdev" xmlns:questionnaire="http://v2.xml.utils.coeus.mit.edu/questionnaire" xmlns:rateandbase="http://v2.xml.utils.coeus.mit.edu/rateandbase" xmlns:rolodex="http://v2.xml.utils.coeus.mit.edu/rolodex" xmlns:sponsor="http://v2.xml.utils.coeus.mit.edu/sponsor" xmlns:user_unit="http://v2.xml.utils.coeus.mit.edu/user_unit" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="''PDF''"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in" margin-right="0.2in">
				<fo:region-body margin-top="1.4in" margin-bottom="0.79in"/>
				<fo:region-before extent="1.4in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:block/>
						<xsl:for-each select="$XML">
							<fo:block/>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block font-family="Arial" font-size="12pt" font-weight="bold" text-align="center" margin="0pt">
								<fo:block>
									<xsl:for-each select="propdev:PROPOSAL">
										<xsl:for-each select="propdev:SCHOOL_INFO_TYPE">
											<xsl:for-each select="propdev:SchoolName">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
														<fo:block>
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:block>
							<fo:block/>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block font-family="Arial" font-size="12pt" font-weight="bold" text-align="center" margin="0pt">
								<fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Proposal Development Summary</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '
								<fo:block/>
							</fo:block>
							<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
								<xsl:text>Proposal Details</xsl:text>
							</fo:inline>
							<fo:inline>
								<xsl:text>&#160;</xsl:text>
							</fo:inline>
							<fo:block/>
							<xsl:for-each select="propdev:PROPOSAL">
								<xsl:for-each select="propdev:PROPOSAL_MASTER">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="18%"/>
										<fo:table-column column-width="34%"/>
										<fo:table-column column-width="10%"/>
										<fo:table-column column-width="38%"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Sponsor:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="sponsor:SPONSOR">
															<xsl:for-each select="sponsor:SPONSOR_CODE">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
															<fo:inline>
																<xsl:text> : </xsl:text>
															</fo:inline>
															<xsl:for-each select="sponsor:SPONSOR_NAME">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Prime Sponsor:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:PRIME_SPONSOR">
															<xsl:for-each select="sponsor:SPONSOR">
																<xsl:for-each select="sponsor:SPONSOR_CODE">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
														';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '					</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																	<fo:inline>
																		<xsl:text> : </xsl:text>
																	</fo:inline>
																</xsl:for-each>
																<xsl:for-each select="sponsor:SPONSOR_NAME">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Proposal Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
															<fo:block>
																<xsl:for-each select="propdev:TITLE">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:block>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Start Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:REQUESTED_START_DATE_INITIAL">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>End Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:REQUESTED_END_DATE_INITIAL">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Proposal Type:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="lookuptypes:PROPOSAL_TYPE">
															<xsl:for-each select="lookuptypes:DESCRIPTION">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Activity Type:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="lookuptypes:ACTIVITY_TYPE">
															<xsl:for-each select="lookuptypes:DESCRIPTION">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Anticipate Award Type:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-c';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'ell>
												<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="lookuptypes:ANTICIPATED_AWARD_TYPE">
															<xsl:for-each select="lookuptypes:DESCRIPTION">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Proposal Deadline Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:DEADLINE_DATE">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</xsl:for-each>
							</xsl:for-each>
							<fo:block/>
							<fo:block/>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROPOSAL/propdev:PROP_INVESTIGATORS  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:block/>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Investigators</xsl:text>
								</fo:inline>
								<fo:inline font-family="Arial" font-size="10pt">
									<xsl:text>&#160;</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="propdev:PROPOSAL/propdev:PROP_INVESTIGATORS_BASIC_DETAILS">
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
										<fo:table-column column-width="25%"/>
										<fo:table-column column-width="45%"/>
										<fo:table-column column-width="10%"/>
										<fo:table-column column-width="10%"/>
										<fo:table-column column-width="10%"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Person Name</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="so';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'lid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Units</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Faculty</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Multi PI</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>%Effort</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="propdev:PROPOSAL">
												<xsl:for-each select="propdev:PROP_INVESTIGATORS_BASIC_DETAILS">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:PERSON_NAME">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																	<xsl:if test="../propdev:PRINCIPAL_INVESTIGATOR_FLAG = &apos;y&apos;">
																		<fo:inline>
																			<xsl:text>(PI)</xsl:text>
																		</fo:inline>
																	</xsl:if>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:PROP_UNITS">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="user_unit:UNIT">
																		<fo:table table-layout="fixed" width="100%" border-spacing="0">
																			<fo:table-column column-width="15%"/>
																			<fo:table-column column-width="85%"/>
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="user_unit:UNIT">
																					<fo:table-row>
																						<fo:table-cell padding="1" display-align="center">
																							<fo:block>
																								<xsl:for-each select="user_unit:UNIT_NUMBER">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of sele';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'ct="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="1" display-align="center">
																							<fo:block>
																								<xsl:for-each select="user_unit:UNIT_NAME">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																									<xsl:if test="../../propdev:LEAD_UNIT_FLAG =&apos;y&apos;">
																										<fo:inline>
																											<xsl:text>(LU)</xsl:text>
																										</fo:inline>
																									</xsl:if>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:if test="propdev:FACULTY_FLAG = &apos;y&apos;">
																	<fo:inline>
																		<xsl:text>Yes</xsl:text>
																	</fo:inline>
																</xsl:if>
																<xsl:if test="propdev:FACULTY_FLAG = &apos;n&apos;">
																	<fo:inline>
																		<xsl:text>No</xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:if test="propdev:MULTI_PI_FLAG = &apos;y&apos;">
																	<fo:inline>
																		<xsl:text>Yes</xsl:text>
																	</fo:inline>
																</xsl:if>																
																<xsl:if test="propdev:MULTI_PI_FLAG =&apos;null&apos;">
																	<fo:inline>
																		<xsl:text>No</xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:PERCENTAGE_EFFORT">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROP_PER_CREDIT_SPLIT  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block ma';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'rgin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Credit Split</xsl:text>
								</fo:inline>
								<fo:block/>
								<xsl:for-each select="propdev:PROPOSAL">
									<xsl:for-each select="propdev:CREDIT_SPLIT_COLUMNS">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="0">
											<fo:table-column column-width="44%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row font-weight="bold">
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnName1">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnName2">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnName3">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnName4">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</xsl:for-each>
								</xsl:for-each>
								<fo:block/>
								<xsl:for-each select="propdev:PROPOSAL">
									<xsl:for-each select="propdev:PROP_PER_CREDIT_SPLIT">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="44%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-column column-width="14%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="propdev:PERSON_NAME">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
												';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '							<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" text-align="right" display-align="center">
														<fo:block>
															<xsl:for-each select="propdev:ColumnValue1">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" text-align="right" display-align="center">
														<fo:block>
															<xsl:for-each select="propdev:ColumnValue2">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" text-align="right" display-align="center">
														<fo:block>
															<xsl:for-each select="propdev:ColumnValue3">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" text-align="right" display-align="center">
														<fo:block>
															<xsl:for-each select="propdev:ColumnValue4">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<xsl:if test="count(  //propdev:PROPOSAL/propdev:PROP_PER_CREDIT_SPLIT/propdev:PROP_UNIT_CREDIT_SPLIT  )  &gt;';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '0">
											<fo:block/>
											<xsl:for-each select="propdev:PROP_UNIT_CREDIT_SPLIT">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="44%"/>
													<fo:table-column column-width="14%"/>
													<fo:table-column column-width="14%"/>
													<fo:table-column column-width="14%"/>
													<fo:table-column column-width="14%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="before">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																		<fo:block>
																			<xsl:for-each select="propdev:UNIT">
																				<fo:inline>
																					<xsl:text>&#160;&#160; </xsl:text>
																				</fo:inline>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline>
																				<xsl:text> :&#160; </xsl:text>
																			</fo:inline>
																			<xsl:for-each select="propdev:UNIT_NAME">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:block>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnValue1">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
		';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '														</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnValue2">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnValue3">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="propdev:ColumnValue4">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</xsl:for-each>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
												<fo:table-column column-width="44%"/>
												<fo:table-column column-width="14%"/>
												<fo:table-column column-width="14%"/>
												<fo:table-column column-width="14%"/>
												<fo:table-column column-width="14%"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row font-weight="bold">
														<fo:table-cell font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Unit Total</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height=';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '"13" text-align="right" display-align="center">
															<fo:block>
																<xsl:if test="string-length(  //propdev:PROPOSAL/propdev:CREDIT_SPLIT_COLUMNS/propdev:ColumnName1  )  &gt; 0">
																	<xsl:for-each select="propdev:TotalUnitColumnValue1">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="13" text-align="right" display-align="center">
															<fo:block>
																<xsl:if test="string-length(  //propdev:PROPOSAL/propdev:CREDIT_SPLIT_COLUMNS/propdev:ColumnName2  )  &gt; 0">
																	<xsl:for-each select="propdev:TotalUnitColumnValue2">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="13" text-align="right" display-align="center">
															<fo:block>
																<xsl:if test="string-length(  //propdev:PROPOSAL/propdev:CREDIT_SPLIT_COLUMNS/propdev:ColumnName3  )  &gt; 0">
																	<xsl:for-each select="propdev:TotalUnitColumnValue3">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
															<fo:block>
																<xsl:if test="string-length(  //propdev:PROPOSAL/propdev:CREDIT_SPLIT_COLUMNS/propdev:ColumnName4  )  &gt; 0">
																	<xsl:for-each select="propdev:TotalUnitColumnValue4">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
				';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '																</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:for-each>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
									<fo:table-column column-width="44%"/>
									<fo:table-column column-width="14%"/>
									<fo:table-column column-width="14%"/>
									<fo:table-column column-width="14%"/>
									<fo:table-column column-width="14%"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row font-weight="bold">
											<fo:table-cell font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Investigator Total111</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border="solid 1pt gray" padding="0" height="13" text-align="right" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:value-of select="format-number(number(sum(  //propdev:PROPOSAL/propdev:PROP_PER_CREDIT_SPLIT/propdev:ColumnValue1  )), ''###,##0.00'')"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border="solid 1pt gray" padding="0" height="13" text-align="right" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:value-of select="format-number(number(sum(  //propdev:PROPOSAL/propdev:PROP_PER_CREDIT_SPLIT/propdev:ColumnValue2  )), ''###,##0.00'')"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border="solid 1pt gray" padding="0" height="13" text-align="right" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:value-of select="format-number(number(sum(  //propdev:PROPOSAL/propdev:PROP_PER_CREDIT_SPLIT/propdev:ColumnValue3  )), ''###,##0.00'')"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border="solid 1pt gray" padding="0" height="13" text-align="right" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:value-of select="format-number(number(sum(  //propdev:PROPOSAL/propdev:PROP_PER_CREDIT_SPLIT/propdev:ColumnValue4 )), ''###,##0.00'')"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:if>
							<fo:block/>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROPOSAL/propdev:PROP_KEY_PERSONS  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
	';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '							<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Study Personnel</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="propdev:PROPOSAL/propdev:PROP_KEY_PERSONS">
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
										<fo:table-column column-width="25%"/>
										<fo:table-column column-width="45%"/>
										<fo:table-column column-width="15%"/>
										<fo:table-column column-width="15%"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" height="1" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Person Name</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" height="1" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Role</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" height="1" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Faculty</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" height="1" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>%Effort</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="propdev:PROPOSAL">
												<xsl:for-each select="propdev:PROP_KEY_PERSONS">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:PERSON_NAME">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:PROJECT_ROLE">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-te';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'mplate"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:if test="propdev:FACULTY_FLAG = &apos;y&apos;">
																	<fo:inline>
																		<xsl:text>Yes</xsl:text>
																	</fo:inline>
																</xsl:if>
																<xsl:if test="propdev:FACULTY_FLAG = &apos;n&apos;">
																	<fo:inline>
																		<xsl:text>No</xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:PERCENTAGE_EFFORT">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROPOSAL/propdev:PROPOSAL_SITES  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:block/>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Organizations</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
									<fo:table-column column-width="20%"/>
									<fo:table-column column-width="30%"/>
									<fo:table-column column-width="50%"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row font-weight="bold">
											<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Type</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Location</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Address</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<xsl:for-each select="propdev:PROPOSAL">
									<xsl:for-each select="propdev:PROPOSAL_SITES">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="20%"/>
											<fo:table-column column-width="30%"/>
											<fo:table-column column-width="50%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
						';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '							<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<xsl:for-each select="lookuptypes:LOCATION">
																<xsl:for-each select="lookuptypes:DESCRIPTION">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<xsl:for-each select="propdev:OrganizationName">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<xsl:for-each select="propdev:RolodexFullAddess">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<xsl:if test="count(  propdev:SiteCOngDistricts  )  &gt; 0">
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" margin-left="(100% - 90%) div 2" margin-right="(100% - 90%) div 2" width="90%" border-spacing="2pt">
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row font-weight="bold">
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>&#160;</xsl:text>
																</fo:inline>
																<fo:inline font-weight="bold">
																	<xsl:text> Congressional District</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:inline-container>
												<fo:blo';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'ck>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<xsl:if test="propdev:SiteCOngDistricts">
												<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" margin-left="(100% - 90%) div 2" margin-right="(100% - 90%) div 2" width="90%" border="solid 1pt gray" border-spacing="-1pt">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<xsl:for-each select="propdev:SiteCOngDistricts">
															<fo:table-row>
																<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:CongDistrict">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</xsl:for-each>
													</fo:table-body>
												</fo:table>
											</xsl:if>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:for-each>
								<fo:block/>
								<fo:block/>
								<fo:block/>
							</xsl:if>
							<fo:block/>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROPOSAL/propdev:PROP_SPECIAL_REVIEW   ) &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Special Review </xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="propdev:PROPOSAL/propdev:PROP_SPECIAL_REVIEW">
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
										<fo:table-column column-width="15%"/>
										<fo:table-column column-width="15%"/>
										<fo:table-column column-width="10%"/>
										<fo:table-column column-width="12%"/>
										<fo:table-column column-width="10%"/>
										<fo:table-column column-width="38%"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Special Review</xsl:text>
													';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '	</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Approval</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Protocol No</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Application Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Approval Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Comments</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="propdev:PROPOSAL">
												<xsl:for-each select="propdev:PROP_SPECIAL_REVIEW">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="lookuptypes:SPECIAL_REVIEW">
																	<xsl:for-each select="lookuptypes:DESCRIPTION">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="lookuptypes:APPLICABLE_REVIEW_TYPE">
																	<xsl:for-each select="lookuptypes:DESCRIPTION">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:PROTOCOL_NUMBER">
																	<xsl:variable name="value-of-templa';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'te">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:APPLICATION_DATE">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:APPROVAL_DATE">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="propdev:COMMENTS">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROPOSAL/propdev:PROP_YNQ  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
					';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '				<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>YNQ</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="propdev:PROPOSAL/propdev:PROP_YNQ">
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
										<fo:table-column column-width="30%"/>
										<fo:table-column column-width="10%"/>
										<fo:table-column column-width="45%"/>
										<fo:table-column column-width="15%"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Question</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Answer</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Explanation</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Review Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="propdev:PROPOSAL">
												<xsl:for-each select="propdev:PROP_YNQ">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="propdev:QUESTION_DESCRIPTION">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:if test="propdev:ANSWER = &apos;y&apos;">
																	<fo:inline>
																		<xsl:text>Yes</xsl:text>
																	</fo:inline>
																</xsl:if>
																';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '<fo:block/>
																<xsl:if test="propdev:ANSWER = &apos;N&apos;">
																	<fo:inline>
																		<xsl:text>No</xsl:text>
																	</fo:inline>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="propdev:EXPLANATION">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:REVIEW_DATE">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block/>
							</fo:block>
							<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
								<xsl:text>Funding Opportunity Information</xsl:text>
							</fo:inline>
							<fo:block/>
							<xsl:for-each select="propdev:PROPOSAL">
								<xsl:for-each select="propdev:PROPOSAL_MASTER">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="18%"/>
										<fo:table-column column-width="82%"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Sponsor Proposal No.:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:bloc';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'k>
														<xsl:for-each select="propdev:SPONSOR_PROPOSAL_NUMBER">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Program Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
															<fo:block>
																<xsl:for-each select="propdev:PROGRAM_ANNOUNCEMENT_TITLE">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:block>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Proposal in Response:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="lookuptypes:NOTICE_OF_OPPORTUNITY">
															<xsl:for-each select="lookuptypes:DESCRIPTION">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Funding Opportunity';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := ':</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:PROGRAM_ANNOUNCEMENT_NUMBER">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>CFDA Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:CFDA_NUMBER">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Original Proposal No.:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:CONTINUED_FROM">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Award No.:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:CURRENT_AWARD_NUMBER">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '
																<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" height="18" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>NSF Science Code:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="propdev:NSF_CODE">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
														
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</xsl:for-each>
							</xsl:for-each>
							<fo:block/>
							<xsl:if test="count(  //budget:BUDGET  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Budget Details</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
														<fo:table-column column-width="17%"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="38%"/>
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
				';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '													<fo:block>
																		<fo:inline>
																			<xsl:text>Budget Status:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:if test="propdev:PROPOSAL/propdev:PROPOSAL_MASTER/propdev:BUDGET_STATUS = &apos;2&apos;">
																			<fo:inline>
																				<xsl:text>InComplete</xsl:text>
																			</fo:inline>
																		</xsl:if>
																		<xsl:if test="propdev:PROPOSAL/propdev:PROPOSAL_MASTER/propdev:BUDGET_STATUS = &apos;1&apos;">
																			<fo:inline>
																				<xsl:text>Complete</xsl:text>
																			</fo:inline>
																		</xsl:if>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Final:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="normal" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:if test="//propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:FINAL_VERSION_FLAG = &apos;y&apos;">
																			<fo:inline>
																				<xsl:text>Yes</xsl:text>
																			</fo:inline>
																		</xsl:if>
																		<xsl:if test="//propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:FINAL_VERSION_FLAG = &apos;n&apos;">
																			<fo:inline>
																				<xsl:text>No</xsl:text>
																			</fo:inline>
																		</xsl:if>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Modular Budget:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:if test="//propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:MODULAR_BUDGET_FLAG = &apos;y&apos;">
																			<fo:inline>
																				<xsl:text>Yes</xsl:text>
																			</fo:inline>
																		</xsl:if>
																		<xsl:if test="//propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:MODULAR_BUDGET_FLAG = &apos;n&apos;">
																			<fo:inline>
																				<xsl:text>No</xsl:text>
																			</fo:inline>
																		</xsl:if>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Submit Cost Sharing:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:if test="propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:SUBMIT_COST_SHARING_FLAG = &apos;y&apos;">
																			<fo:inline>
																				<xsl:text>Yes</xsl:text>
																			</fo:inline>
																		</xsl:if>
																		<xsl:if test="propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:SUBMIT_COST_SHARING_FLAG = &apos;n&apos;">
																			<fo:inline>
																				<xsl:text>No</xsl:text>
																			</fo:i';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'nline>
																		</xsl:if>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>on/off Campus:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:ON_OFF_CAMPUS_FLAG">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Total Cost Limit:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:TOTAL_COST_LIMIT">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Residual Funds:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:RESIDUAL_FUNDS">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																		';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '			</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Total Direct Cost Limit:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:TOTAL_DIRECT_COST_LIMIT">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Direct Cost:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:TOTAL_DIRECT_COST">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Indirect Cost:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:TOTAL_INDIRECT_COST">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
														';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '				<fo:inline>
																			<xsl:text>Total Cost:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:TOTAL_COST">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Under Recovery:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:UNDERRECOVERY_AMOUNT">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Cost Share:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:COST_SHARING_AMOUNT">
																						<fo:inline>
																							<xsl:text>$</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="format-number(number(string(.)), ''###,##0.00'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Period:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
				';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '																<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:START_DATE">
																						<fo:inline>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																						</fo:inline>
																					</xsl:for-each>
																					<fo:inline>
																						<xsl:text>&#160; - </xsl:text>
																					</fo:inline>
																					<xsl:for-each select="budget:END_DATE">
																						<fo:inline>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>OverHead Rate Type:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:OH_RATE_TYPE_DESCRIPTION">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell font-weight="bold" number-columns-spanned="4" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Under Recovery Rate Type:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="2pt" display-align="center">
																	<fo:block>
																		<xsl:for-each select="propdev:PROPOSAL">
																			<xsl:for-each select="budget:BUDGET">
																				<xsl:for-each select="budget:BudgetMaster">
																					<xsl:for-each select="budget:UR_RATE_TYPE_DESCRIPTION">
																				';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '		<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Comments:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="8" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																			<fo:block>
																				<xsl:for-each select="propdev:PROPOSAL">
																					<xsl:for-each select="budget:BUDGET">
																						<xsl:for-each select="budget:BudgetMaster">
																							<xsl:for-each select="budget:COMMENTS">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block/>
								<xsl:if test="count(  //propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:BUDGET_PERIOD  )  &gt; 0">
									<fo:block/>
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:block/>
									</fo:block>
									<fo:block/>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Budget Periods</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
										';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '	<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="propdev:PROPOSAL/budget:BUDGET/budget:BudgetMaster/budget:BUDGET_PERIOD">
										<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="5%"/>
											<fo:table-column column-width="10%"/>
											<fo:table-column column-width="10%"/>
											<fo:table-column column-width="15%"/>
											<fo:table-column column-width="12%"/>
											<fo:table-column column-width="12%"/>
											<fo:table-column column-width="12%"/>
											<fo:table-column column-width="12%"/>
											<fo:table-column column-width="12%"/>
											<fo:table-header start-indent="0pt">
												<fo:table-row font-weight="bold">
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Period</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Start Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>End Date</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>No. of Months</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Direct Cost</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Indirect Cost</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Under Recovery</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Cost Sharing</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Total Cost</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:for-each select="propdev:PROPOSAL">
													<xsl:for-each select="budget:BUDGET">
														<xsl:for-each select="budget:BudgetMaster">
															<xsl:for-each select="budget:BUDGET_PERIOD">
																<fo:table-row>
																	<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:BUDGET_PERIOD_NUMBER">
																				<xsl:variable name="value-of-temp';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'late">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:START_DATE">
																				<fo:inline>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																					<xsl:text>/</xsl:text>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																					<xsl:text>/</xsl:text>
																					<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																				</fo:inline>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:END_DATE">
																				<fo:inline>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																					<xsl:text>/</xsl:text>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																					<xsl:text>/</xsl:text>
																					<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																				</fo:inline>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:NO_OF_MONTHS">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:TOTAL_DIRECT_COST">
																				<fo:inline>
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
													';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '									</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:TOTAL_INDIRECT_COST">
																				<fo:inline>
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:UNDERRECOVERY_AMOUNT">
																				<fo:inline>
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:COST_SHARING_AMOUNT">
																				<fo:inline>
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																		<fo:block>
																			<xsl:for-each select="budget:TOTAL_COST">
																				<fo:inline>
												';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '									<xsl:text>$</xsl:text>
																				</fo:inline>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<fo:block/>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROP_ABSTRACT  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Abstract</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="propdev:PROPOSAL/propdev:PROP_ABSTRACT">
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="30%"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="propdev:PROPOSAL">
												<xsl:for-each select="propdev:PROP_ABSTRACT">
													<fo:table-row font-weight="normal">
														<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="lookuptypes:ABSTRACT_TYPE">
																			<xsl:for-each select="lookuptypes:DESCRIPTION">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>:</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
											';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '			<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																	<fo:block>
																		<xsl:for-each select="propdev:ABSTRACT">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROP_CUSTOM_DATA  )  &gt; 0">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Others</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="propdev:PROPOSAL/propdev:PROP_CUSTOM_DATA">
									<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="40%"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="propdev:PROPOSAL">
												<xsl:for-each select="propdev:PROP_CUSTOM_DATA">
													<fo:table-row>
														<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:COLUMN_NAME">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																	<fo:inline>
																		<xsl:text>:</xsl:text>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="propdev:COLUMN_VALUE">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROPOSAL/propdev:ROUTING_DETAILS/approvalRouting:RoutingMaps  )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Routing Details</xsl:text>
								</fo:inline>
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:block/>
								<xsl:for-each select="propdev:PROPOSAL">
									<xsl:for-each select="propdev:ROUTING_DETAILS">
										<xsl:for-each select="approvalRouting:RoutingMaps">
											<fo:block/>
											<xsl:for-each select="approvalRouting:Description">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
														<fo:block font-family="Arial" font-size="9pt" font-weight="bold">
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
											<fo:block/>
											<xsl:for-each select="approvalRouting:LevelDetails">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Sequential Stop </xsl:text>
																	</fo:inline>
																	<xsl:for-each select="approvalRouting:LevelNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																				<fo:block font-weight="bold">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
								';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '											<xsl:otherwise>
																				<fo:inline font-weight="bold">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row font-family="Arial" font-size="9pt" font-weight="normal">
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="approvalRouting:RoutingDetails">
																		<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-header start-indent="0pt">
																				<fo:table-row font-weight="bold">
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline>
																								<xsl:text>User Name(User Id)</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline>
																								<xsl:text>Approval Type</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																						<fo:block>
																							<fo:inline>
																								<xsl:text>Approval Status</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-header>
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="approvalRouting:RoutingDetails">
																					<fo:table-row font-weight="normal">
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:for-each select="approvalRouting:UserName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																								<xsl:for-each select="approvalRouting:UserId">
																									<fo:inline>
																										<xsl:text>(</xsl:text>
																									</fo:inline>
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																							';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '		<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																									<fo:inline>
																										<xsl:text>)</xsl:text>
																									</fo:inline>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:if test="approvalRouting:PrimaryApproverFlag = &apos;y&apos;">
																									<fo:inline>
																										<xsl:text>Primary Approver</xsl:text>
																									</fo:inline>
																								</xsl:if>
																								<xsl:if test="approvalRouting:PrimaryApproverFlag = &apos;n&apos;">
																									<fo:inline>
																										<xsl:text>Secondary Approver</xsl:text>
																									</fo:inline>
																								</xsl:if>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:for-each select="approvalRouting:ApprovalStatus">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
							<fo:block/>
							<xsl:if test="count(  //propdev:PROPOSAL/propdev:ROUTING_DETAILS/approvalRouting:RoutingMaps )  &gt; 0">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:block/>
								<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
									<xsl:text>Routing Comments</xsl:text>
								</fo:inline>
								<fo:block/>
								<xsl:for-each select="propdev:PROPOSAL">
									<xsl:for-each select="propdev:ROUTING_COMMENTS">
										<xsl:for-each select="approvalRouting:RoutingMaps">
											<fo:block/>
											<xsl:for-each select="approv';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'alRouting:RoutingDetails">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																		<fo:table-column column-width="40%"/>
																		<fo:table-column column-width="35%"/>
																		<fo:table-column column-width="25%"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row font-family="Arial" font-size="9pt" font-weight="bold">
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<xsl:for-each select="approvalRouting:UserName">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																						<fo:inline>
																							<xsl:text>(</xsl:text>
																						</fo:inline>
																						<xsl:for-each select="approvalRouting:UserId">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																						<fo:inline>
																							<xsl:text>)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<xsl:for-each select="approvalRouting:RoutingComments">
																							<xsl:for-each select="approvalRouting:MapNameDescription">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<xsl:for-each select="approvalRouting:ApprovalStatus">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="approvalRouting:RoutingComments">
																		<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																			<fo:table-column column-width="75%"/>
																			<fo:table-column column-width="25%"/>
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="approvalRouting:RoutingComments">
																					<fo:table-row>
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:for-each select="approvalRouting:Comments">
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																										<fo:block>
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</fo:block>
																									</fo:block>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																							<fo:block>
																								<xsl:f';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'or-each select="approvalRouting:UpdateTimestamp">
																									<fo:inline>
																										<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
																										<xsl:text>/</xsl:text>
																										<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
																										<xsl:text>/</xsl:text>
																										<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
																										<xsl:text> </xsl:text>
																										<xsl:value-of select="format-number(number(substring(string(string(.)), 12, 2)), ''00'')"/>
																										<xsl:text>:</xsl:text>
																										<xsl:value-of select="format-number(number(substring(string(string(.)), 15, 2)), ''00'')"/>
																										<xsl:text>:</xsl:text>
																										<xsl:choose>
																											<xsl:when test="contains(string(string(.)), ''Z'')">
																												<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), ''Z''), '':''), '':'')), ''00'')"/>
																											</xsl:when>
																											<xsl:when test="contains(string(string(.)), ''+'')">
																												<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), ''+''), '':''), '':'')), ''00'')"/>
																											</xsl:when>
																											<xsl:when test="contains(substring(string(string(.)), 18), ''-'')">
																												<xsl:value-of select="format-number(number(substring-before(substring(string(string(.)), 18), ''-'')), ''00'')"/>
																											</xsl:when>
																											<xsl:otherwise>
																												<xsl:value-of select="format-number(number(substring(string(string(.)), 18)), ''00'')"/>
																											</xsl:otherwise>
																										</xsl:choose>
																									</fo:inline>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
						</xsl:for-each>
						<fo:block/>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table font-family="Arial" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="15%"/>
						<fo:table-column column-width="30%"/>
						<fo:table-column column-width="40%"/>
						<fo:table-column column-width="15%"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0" number-columns-spanned="4" height="18" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0" number-columns-spanned="4" height="18" display-align="center">
									<fo:block>
										<xsl:for-each select="propdev:PROPOSAL">
											<xsl:for-each select="propdev:SCHOOL_INFO_TYPE">
												<xsl:for-each select="prop';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := 'dev:Acronym">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
															<fo:block>
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline>
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
											<fo:inline>
												<xsl:text>&#160;</xsl:text>
											</fo:inline>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text>Proposal Number: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" padding-bottom="0" padding-left="0" padding-top="1pt" padding="2pt" text-align="left" display-align="after">
									<fo:block>
										<xsl:for-each select="propdev:PROPOSAL">
											<xsl:for-each select="propdev:PROPOSAL_MASTER">
												<xsl:for-each select="propdev:PROPOSAL_NUMBER">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
															<fo:block>
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline>
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" font-weight="bold" padding-bottom="0" padding-right="5pt" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text>Date Generated: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="propdev:PROPOSAL">
											<xsl:for-each select="propdev:CUR_DATE">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
														<fo:block>
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-weight="bold" padding-top="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text>Lead PI:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family=';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '"Arial" padding-left="0" padding-top="0" number-columns-spanned="3" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="propdev:PROPOSAL">
											<xsl:for-each select="propdev:PROPOSAL_MASTER">
												<xsl:for-each select="propdev:PRINCIPAL_INVESTIGATOR_NAME">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
															<fo:block>
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline>
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-weight="bold" padding-top="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<fo:inline font-family="Arial" font-size="9pt" font-weight="bold">
											<xsl:text>Sponsor:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" padding-left="0" padding-top="0" number-columns-spanned="3" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="propdev:PROPOSAL">
											<xsl:for-each select="propdev:PROPOSAL_MASTER">
												<xsl:for-each select="sponsor:SPONSOR">
													<xsl:for-each select="sponsor:SPONSOR_CODE">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates/>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																<fo:block>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
														<fo:inline>
															<xsl:text> : </xsl:text>
														</fo:inline>
													</xsl:for-each>
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
										<fo:inline>
											<xsl:text>&#160;</xsl:text>
										</fo:inline>
										<xsl:for-each select="propdev:PROPOSAL">
											<xsl:for-each select="propdev:PROPOSAL_MASTER">
												<xsl:for-each select="sponsor:SPONSOR">
													<xsl:for-each select="sponsor:SPONSOR_NAME">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates/>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
																<fo:block>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="9pt" padding="0" padding-top="0" number-columns-spanned="4" text-align="left" display-align="before';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES
WHERE
SPONSOR_FORM_ID =(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE='999999' and PACKAGE_NUMBER=3) AND PAGE_NUMBER = 1 FOR UPDATE;
buffer := '">
									<fo:block>
										<fo:block text-align="center">
											<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
										</fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, ''\'')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = ''\''">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
commit;
