---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
DECLARE

  TRANS_DETAIL_ID NUMBER(10);
  TNM_DOC_NUMBER varchar2(40);
  NEXT_TRANS_ID NUMBER(10);

  CURSOR TRANS_DETAIL_CUR IS SELECT TRANSACTION_DETAIL_ID, TNM_DOCUMENT_NUMBER FROM TRANSACTION_DETAILS WHERE TRANSACTION_ID = '-1';

BEGIN

  OPEN TRANS_DETAIL_CUR;

  LOOP
    FETCH TRANS_DETAIL_CUR INTO TRANS_DETAIL_ID, TNM_DOC_NUMBER;
    EXIT WHEN TRANS_DETAIL_CUR%NOTFOUND;

    SELECT SEQ_TRANSACTION_ID.NEXTVAL INTO NEXT_TRANS_ID FROM DUAL;

    UPDATE TRANSACTION_DETAILS SET TRANSACTION_DETAIL_TYPE = 'DATE', TRANSACTION_ID = NEXT_TRANS_ID WHERE TRANSACTION_DETAIL_ID = TRANS_DETAIL_ID;
    UPDATE AWARD_AMOUNT_INFO SET TRANSACTION_ID = NEXT_TRANS_ID WHERE TNM_DOCUMENT_NUMBER = TNM_DOC_NUMBER AND TRANSACTION_ID IS NULL;
  END LOOP;

  CLOSE TRANS_DETAIL_CUR;
END;
/
