---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


  CREATE TABLE cx_hrapi_import_status (
    importId                VARCHAR2(50) NOT NULL PRIMARY KEY,
    status                  VARCHAR2(20) DEFAULT 'PROCESSING' NOT NULL,
    startTime               NUMBER(19, 0) NOT NULL,
    endTime                 NUMBER(19, 0) DEFAULT -1,
    numRecords              INT DEFAULT 0,
    numProcessed            INT DEFAULT 0,
    detail                  CLOB
  );

  CREATE SEQUENCE SEQ_CX_HRAPI_ERROR_ID INCREMENT BY 1 START WITH 1 NOCACHE;

  CREATE TABLE cx_hrapi_import_errors (
    errorId                 INT PRIMARY KEY,
    importId                VARCHAR2(50) NOT NULL,
    recordNum               INT,
    principalName           VARCHAR2(100),
    exception               BLOB,

    CONSTRAINT FK_IMPORT FOREIGN KEY (importId)
    REFERENCES cx_hrapi_import_status(importId)
    ON DELETE CASCADE
  );

  CREATE TABLE cx_hrapi_import_persons (
    personId                VARCHAR2(40) PRIMARY KEY NOT NULL,
    importId                VARCHAR2(50) NOT NULL,
    recordStatus            VARCHAR2(8) DEFAULT 'ADDED' NOT NULL,

    CONSTRAINT FK_cx_hrapi_import_status FOREIGN KEY (importId)
    REFERENCES cx_hrapi_import_status(importId)
    ON DELETE CASCADE
  );

