---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


INSERT INTO SPONSOR_FORM_TEMPLATES (SPONSOR_FORM_TEMPLATE_ID,SPONSOR_FORM_ID,PAGE_NUMBER,PAGE_DESCRIPTION,FILE_NAME,CONTENT_TYPE,FORM_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (SEQ_SPONSOR_FORM_TEMPLATES.NEXTVAL,(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)'),9,'Page 2-Performance Sites Key Personnel','Page 2-Performance Sites Key Personnel.xslt','text/xml',EMPTY_CLOB(),'admin',SYSDATE,SYS_GUID(),1);
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://era.nih.gov/Projectmgmt/SBIR/CGAP/common.namespace" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:nih="http://era.nih.gov/Projectmgmt/SBIR/CGAP/nihspecific.namespace" xmlns:phs398="http://era.nih.gov/Projectmgmt/SBIR/CGAP/phs398.namespace" xmlns:rar="http://era.nih.gov/Projectmgmt/SBIR/CGAP/researchandrelated.namespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="''PDF''"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="even-page-master" margin-left="0.6in" margin-right="0.6in" page-height="11in" page-width="8.5in">
                <fo:region-body margin-top=".6in" margin-bottom="1in"/>
                <fo:region-after region-name="even-page-footer" extent="1in"/>
            </fo:simple-page-master>
            <fo:simple-page-master master-name="odd-page-master" margin-left="0.6in" margin-right="0.6in" page-height="11in" page-width="8.5in">
                <fo:region-body margin-top=".6in" margin-bottom="1in"/>
                <fo:region-after region-name="odd-page-footer" extent="1in"/>
            </fo:simple-page-master>
            <fo:page-sequence-master master-name="default-page">
                <fo:repeatable-page-master-alternatives>
                    <fo:conditional-page-master-reference master-reference="odd-page-master" odd-or-even="odd"/>
                    <fo:conditional-page-master-reference master-reference="even-page-master" odd-or-even="even"/>
                </fo:repeatable-page-master-alternatives>
            </fo:page-sequence-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <xsl:call-template name="footerodd"/>
                <xsl:call-template name="footereven"/>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <xsl:for-each select="$XML">
                            <fo:inline font-size="8pt">
                                <xsl:text>Program Director/Principal Investigator (Last, First,&#160; Middle): </xsl:text>
                            </fo:inline>
                            <xsl:for-each select="nih:ResearchAndRelatedProject">
                                <xsl:for-each select="nih:ResearchCoverPage">
                                    <xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
                                        <xsl:for-each select="Name">
                                            <xsl:for-each select="LastName">
                                                <xsl:variable name="value-of-template">
                                                    <xsl:apply-templates/>
                                                </xsl:variable>
                                                <xsl:choose>
                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                        <fo:block font-family="Verdana" font-size="8pt">
                                                            <xsl:copy-of select="$value-of-template"/>
                                                        </fo:block>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <fo:inline font-family="Verdana" font-size="8pt">
                                                            <xsl:copy-of select="$value-of-template"/>
                                                        </fo:inline>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:for-each>
                                            <fo:inline border-top=".3in" font-size="8pt" margin-top="inherit">
                                                <xsl:text>, </xsl:text>
                                            </fo:inline>
                                            <xsl:for-each select="FirstName">
                                                <xsl:variable name="value-of-template">
                                                    <xsl:apply-templates/>
                                                </xsl:variable>
                                                <xsl:choose>
                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                        <fo:block font-family="Verdana" font';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '-size="8pt">
                                                            <xsl:copy-of select="$value-of-template"/>
                                                        </fo:block>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <fo:inline font-family="Verdana" font-size="8pt">
                                                            <xsl:copy-of select="$value-of-template"/>
                                                        </fo:inline>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="4.4in" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>PROJECT SUMMARY (See instructions):</xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                            <xsl:for-each select="Abstract">
                                                                <xsl:for-each select="AbstractText">
                                                                    <xsl:if test="../AbstractTypeCode =1">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                <fo:block font-family="Verdana" font-size="8pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="1.4in" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>RELEVANCE (See instructions):</xsl:text>
                                                </fo:inline>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                            <xsl:for-each select="Abstract">
                                                                <xsl:for-each select="AbstractText">
                                                                    <xsl:if test="../AbstractTypeCode =17">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                <fo:block font-family="Verdana" font-size="8pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := 'when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:inline font-size="8pt">
                                <xsl:text>PROJECT/PERFORMANCE SITE(S) (if additional space is needed, use Project/Performance Site Format Page)</xsl:text>
                            </fo:inline>
                            <fo:block/>
                            <fo:inline font-size="8pt" font-weight="bold" line-height="normal">
                                <xsl:text>Project/Performance Site Primary Location</xsl:text>
                            </fo:inline>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body padding="0" start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell padding="0" number-columns-spanned="3" border="solid 1pt gray" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt" line-height="9pt">
                                                    <xsl:text>Organizational Name:</xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:text>&#160; </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="PrimaryProjectSite">
                                                            <xsl:for-each select="OrganizationName">
                                                                <xsl:variable name="value-of-template">
                                                                    <xsl:apply-templates/>
                                                                </xsl:variable>
                                                                <xsl:choose>
                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                        <fo:block font-family="Verdana">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:block>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline font-family="Verdana">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding="0" number-columns-spanned="3" border="solid 1pt gray" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>DUNS: </xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell line-height="inherit" border="solid 1pt gray" padding="2pt" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Street1:&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/PrimaryProjectSite/PostalAddress/Street[1]"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell line-height="normal" number-columns-s';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := 'panned="2" border="solid 1pt gray" padding="2pt" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Street2:</xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:text>&#160;&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/PrimaryProjectSite/PostalAddress/Street[2]"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell line-height="inherit" border="solid 1pt gray" padding="2pt" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>City: </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="PrimaryProjectSite">
                                                            <xsl:for-each select="PostalAddress">
                                                                <xsl:for-each select="City">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Verdana">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Verdana">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell line-height="normal" border="solid 1pt gray" padding="2pt" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>County: </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="PrimaryProjectSite">
                                                            <xsl:for-each select="CountyName">
                                                                <xsl:variable name="value-of-template">
                                                                    <xsl:apply-templates/>
                                                                </xsl:variable>
                                                                <xsl:choose>
                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                        <fo:block font-family="Verdana">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:block>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline font-family="Verdana">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell line-height="normal" border="solid 1pt gray" padding="2pt" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>State:</xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="PrimaryProjectSite">
                                                            <xsl:for-each sele';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := 'ct="PostalAddress">
                                                                <xsl:for-each select="State">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Verdana">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Verdana">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row line-height="inherit">
                                        <fo:table-cell line-height="inherit" border="solid 1pt gray" padding="2pt" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Province:</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell line-height="normal" border="solid 1pt gray" padding="2pt" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Country:&#160; </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="PrimaryProjectSite">
                                                            <xsl:for-each select="PostalAddress">
                                                                <xsl:for-each select="Country">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Verdana">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Verdana">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell line-height="normal" border="solid 1pt gray" padding="2pt" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Zip/Postal Code:</xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="PrimaryProjectSite">
                                                            <xsl:for-each select="PostalAddress">
                                                                <xsl:for-each select="PostalCode">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Verdana" font-size="8pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Verdana" font-size="8';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := 'pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell padding="0" number-columns-spanned="3" border="solid 1pt gray" height="10pt" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="PrimaryProjectSite">
                                                            <xsl:for-each select="CongressionalDistrict">
                                                                <xsl:variable name="value-of-template">
                                                                    <xsl:apply-templates/>
                                                                </xsl:variable>
                                                                <xsl:choose>
                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                        <fo:block font-family="Verdana" font-size="8pt">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:block>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline font-family="Verdana" font-size="8pt">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:inline font-size="8pt" font-weight="bold">
                                <xsl:text>Additional Project/Performance Site Location</xsl:text>
                            </fo:inline>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Organizational Name:&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/OrganizationName"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>DUNS: </xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Street1: </xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
            ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '                                     <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/PostalAddress/Street[1]"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Street2:&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/PostalAddress/Street[2]"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>City:&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/PostalAddress/City"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>County:&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/CountyName"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>State: </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/PostalAddress/State"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Province:</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Country:&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/PostalAddress/Country"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Zip/Postal Code:&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/PostalAddress/PostalCode"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Project/Performance Site Congressiona';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := 'l Districts:</xsl:text>
                                                </fo:inline>
                                                <fo:inline>
                                                    <xsl:text>&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                    <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[1]/CongressionalDistrict"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:block break-after="page">
                                <fo:leader leader-pattern="space"/>
                            </fo:block>
                            <fo:block/>
                            <fo:inline font-size="8pt">
                                <xsl:text>SCIENTIFIC/KEY PERSONNEL. See instructions. Use continuation pages as needed to providce the required information in the format shown below. Start with Program Director/Principal Investigator(s). List all other key personnel in alphabetical order, last name first.</xsl:text>
                            </fo:inline>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table display-align="before" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="2.4in" display-align="before">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <xsl:if test="nih:ResearchAndRelatedProject/KeyPerson">
                                                    <fo:table font-size="8pt" table-layout="fixed" width="100%" border-spacing="2pt">
                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                        <fo:table-header start-indent="0pt">
                                                            <fo:table-row>
                                                                <fo:table-cell padding="2pt" display-align="before">
                                                                    <fo:block>
                                                                        <fo:inline>
                                                                            <xsl:text>Name</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell padding="2pt" display-align="before">
                                                                    <fo:block>
                                                                        <fo:inline>
                                                                            <xsl:text>eRA Commons User Name</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                    <fo:block>
                                                                        <fo:inline>
                                                                            <xsl:text>OrganizationName</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                    <fo:block>
                                                                        <fo:inline>
                                                                            <xsl:text>Role On Project</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-header>
                                                        <fo:table-body start-indent="0pt">
                                                            <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                                <xsl:for-each select="KeyPerson">
                                                                    <fo:table-row>
                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                            <fo:block>
                                                                                <xsl:if test="keyPersonFlag/keyPersonFlagCode =&quot;true&quot;">
                                                                                    <xsl:for-each select="Name">
                                                                                        <xsl:for-each select="FirstName">
                                                                                            <xsl:variable name="value-of-template">
                                                ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '                                             <xsl:apply-templates/>
                                                                                            </xsl:variable>
                                                                                            <xsl:choose>
                                                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                    <fo:block font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:block>
                                                                                                </xsl:when>
                                                                                                <xsl:otherwise>
                                                                                                    <fo:inline font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:inline>
                                                                                                </xsl:otherwise>
                                                                                            </xsl:choose>
                                                                                        </xsl:for-each>
                                                                                        <fo:inline>
                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                        </fo:inline>
                                                                                        <xsl:for-each select="LastName">
                                                                                            <xsl:variable name="value-of-template">
                                                                                                <xsl:apply-templates/>
                                                                                            </xsl:variable>
                                                                                            <xsl:choose>
                                                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                    <fo:block font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:block>
                                                                                                </xsl:when>
                                                                                                <xsl:otherwise>
                                                                                                    <fo:inline font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:inline>
                                                                                                </xsl:otherwise>
                                                                                            </xsl:choose>
                                                                                        </xsl:for-each>
                                                                                    </xsl:for-each>
                                                                                </xsl:if>
                                                                            </fo:block>
                                                                        </fo:table-cell>
                                                                        <fo:table-cell padding="2pt" display-align="before">
                                                                            <fo:block>
                                                                                <xsl:if test="keyPersonFlag/keyPersonFlagCode =&quot;true&quot; and nih:AccountIdentifier != &apos;Unknown&apos;">
                                                                                    <xsl:for-each select="nih:AccountIdentifier">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                        </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-family="Verdana">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline font-family="Verdana">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:for-each>
                                                                                </xsl:if>
                                                                            </fo:block>
                                                                        </fo:table-cell>
                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                            <fo:block>
                                                                                <xsl:if test="keyPersonFlag/keyPersonFlagCode =&quot;true&quot;">
                                                                                    <xsl:for-each select="OrganizationName">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                        </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-family="Verdana" font-size="8pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline font-family="Verdana" font-size="8pt">
                                                                                                    <xsl:copy-of select="$value-of-template';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:for-each>
                                                                                </xsl:if>
                                                                            </fo:block>
                                                                        </fo:table-cell>
                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                            <fo:block>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="keyPersonFlag/keyPersonFlagCode =&quot;true&quot; and  keyPersonFlag/keyPersonFlagDesc = &apos;PI&apos;">
                                                                                        <fo:inline>
                                                                                            <xsl:text>Principal Investigator</xsl:text>
                                                                                        </fo:inline>
                                                                                    </xsl:when>
                                                                                    <xsl:when test="keyPersonFlag/keyPersonFlagCode = &quot;true&quot; and  keyPersonFlag/keyPersonFlagDesc != &apos;PI&apos;">
                                                                                        <xsl:for-each select="nih:RoleOnProject">
                                                                                            <xsl:variable name="value-of-template">
                                                                                                <xsl:apply-templates/>
                                                                                            </xsl:variable>
                                                                                            <xsl:choose>
                                                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                    <fo:block>
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:block>
                                                                                                </xsl:when>
                                                                                                <xsl:otherwise>
                                                                                                    <fo:inline>
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:inline>
                                                                                                </xsl:otherwise>
                                                                                            </xsl:choose>
                                                                                        </xsl:for-each>
                                                                                    </xsl:when>
                                                                                </xsl:choose>
                                                                            </fo:block>
                                                                        </fo:table-cell>
                                                                    </fo:table-row>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:block/>
                            <fo:block text-align="center">
                                <fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%"/>
                            </fo:block>
                            <fo:block/>
                            <fo:inline font-size="8pt">
                                <xsl:text>OTHER SIGNIFICANT CONTRIBUTORS</xsl:text>
                            </fo:inline>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="2.4in" display-align="before">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <xsl:if test="nih:ResearchAndRelatedProject/KeyPerson">
                                                    <fo:table font-size="8pt" table-layout="fixed" width="100%" border-spacing="2pt">
                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                        <fo:table-header start-indent="0pt">
                                                            <fo:table-row>
                                                                <fo:table-cell padding="2pt" display-align="before">
                                                                    <fo:block>
                                                                        <fo:inline>
                                                                            <xsl:text>Name</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                    <fo:block>
                                                                        <fo:inline>
                        ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '                                                 <xsl:text>Organization Name</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                    <fo:block>
                                                                        <fo:inline>
                                                                            <xsl:text>Role On Project</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-header>
                                                        <fo:table-body start-indent="0pt">
                                                            <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                                <xsl:for-each select="KeyPerson">
                                                                    <fo:table-row>
                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                            <fo:block>
                                                                                <xsl:if test="keyPersonFlag/keyPersonFlagCode =&quot;false&quot;">
                                                                                    <xsl:for-each select="Name">
                                                                                        <xsl:for-each select="FirstName">
                                                                                            <xsl:variable name="value-of-template">
                                                                                                <xsl:apply-templates/>
                                                                                            </xsl:variable>
                                                                                            <xsl:choose>
                                                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                    <fo:block font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:block>
                                                                                                </xsl:when>
                                                                                                <xsl:otherwise>
                                                                                                    <fo:inline font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:inline>
                                                                                                </xsl:otherwise>
                                                                                            </xsl:choose>
                                                                                        </xsl:for-each>
                                                                                        <fo:inline>
                                                                                            <xsl:text>&#160;</xsl:text>
                                                                                        </fo:inline>
                                                                                        <xsl:for-each select="LastName">
                                                                                            <xsl:variable name="value-of-template">
                                                                                                <xsl:apply-templates/>
                                                                                            </xsl:variable>
                                                                                            <xsl:choose>
                                                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                    <fo:block font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:block>
                                                                                                </xsl:when>
                                                                                                <xsl:otherwise>
                                                                                                    <fo:inline font-family="Verdana">
                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                    </fo:inline>
                                                                                                </xsl:otherwise>
                                                                                            </xsl:choose>
                                                                                        </xsl:for-each>
                                                                                    </xsl:for-each>
                                                                                </xsl:if>
                                                                            </fo:block>
                                                                        </fo:table-cell>
                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                            <fo:block>
                                                                                <xsl:if test="keyPersonFlag/keyPersonFlagCode =&quot;false&quot;">
                                                                                    <xsl:for-each select="OrganizationName">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                        </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-family="Verdana">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline font-family="Verdana">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:for-each>
';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '                                                                             </xsl:if>
                                                                            </fo:block>
                                                                        </fo:table-cell>
                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                            <fo:block>
                                                                                <xsl:if test="keyPersonFlag/keyPersonFlagCode =&quot;false&quot;">
                                                                                    <xsl:for-each select="nih:RoleOnProject">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                        </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-family="Verdana">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline font-family="Verdana">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:for-each>
                                                                                </xsl:if>
                                                                            </fo:block>
                                                                        </fo:table-cell>
                                                                    </fo:table-row>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:block/>
                            <fo:block text-align="center">
                                <fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%"/>
                            </fo:block>
                            <fo:block/>
                            <fo:inline font-size="8pt">
                                <xsl:text>Human Embyonic Stem Cells</xsl:text>
                            </fo:inline>
                            <fo:inline>
                                <xsl:text>&#160;&#160;&#160; </xsl:text>
                            </fo:inline>
                            <xsl:for-each select="nih:ResearchAndRelatedProject">
                                <xsl:for-each select="nih:ProjectDescription">
                                    <xsl:for-each select="rar:ProjectSurvey">
                                        <xsl:for-each select="StemCellQuestion">
                                            <xsl:choose>
                                                <xsl:when test="string(.)=''false''">
                                                    <fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
                                                        <xsl:text>&#x2714;</xsl:text>
                                                    </fo:inline>
                                                </xsl:when>
                                                <xsl:when test="string(.)=''0''">
                                                    <fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
                                                        <xsl:text>&#x2714;</xsl:text>
                                                    </fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline border="solid 1pt black">
                                                        <fo:leader leader-length="10pt" leader-pattern="space"/>
                                                    </fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <fo:inline font-size="8pt">
                                                <xsl:text>No&#160;&#160; </xsl:text>
                                            </fo:inline>
                                        </xsl:for-each>
                                        <xsl:for-each select="StemCellQuestion">
                                            <xsl:choose>
                                                <xsl:when test="string(.)=''true''">
                                                    <fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
                                                        <xsl:text>&#x2714;</xsl:text>
                                                    </fo:inline>
                                                </xsl:when>
                                                <xsl:when test="string(.)=''1''">
                                                    <fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
                                                        <xsl:text>&#x2714;</xsl:text>
                                                    </fo:inline>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline border="solid 1pt black">
                                                        <fo:leader leader-length="10pt" leader-pattern="space"/>
                                                    </fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <fo:inline>
                                                <xsl:text>&#160;</xsl:text>
                                            </fo:inline>
                                            <fo:inline font-size="8pt">
                                                <xsl:text>Ye';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := 's</xsl:text>
                                            </fo:inline>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                            <fo:block/>
                            <fo:inline font-size="8pt" line-height="9pt">
                                <xsl:text>If the proposed project involves human embryonic stem cells, list below the registration number of the specific cell line(s) from the following list:</xsl:text>
                            </fo:inline>
                            <fo:block/>
                            <fo:inline font-size="8pt" line-height="9pt">
                                <xsl:text>http://stemcells.nih.gov/research/registry. Use continuation pages as needed.</xsl:text>
                            </fo:inline>
                            <fo:block/>
                            <fo:inline font-size="8pt" line-height="9pt">
                                <xsl:text>If a specific line cannot be referenced at this time, include a statement that one from the Registry will be used.</xsl:text>
                            </fo:inline>
                            <fo:block/>
                            <fo:block text-align="center">
                                <fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%"/>
                            </fo:block>
                            <fo:block/>
                            <fo:inline font-size="8pt">
                                <xsl:text>Cell Line</xsl:text>
                            </fo:inline>
                            <fo:block/>
                            <xsl:for-each select="nih:ResearchAndRelatedProject">
                                <xsl:for-each select="nih:ProjectDescription">
                                    <xsl:for-each select="rar:ProjectSurvey">
                                        <xsl:for-each select="StemCellText">
                                            <xsl:variable name="value-of-template">
                                                <xsl:apply-templates/>
                                            </xsl:variable>
                                            <xsl:choose>
                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                    <fo:block font-family="Verdana" font-size="8pt">
                                                        <xsl:copy-of select="$value-of-template"/>
                                                    </fo:block>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <fo:inline font-family="Verdana" font-size="8pt">
                                                        <xsl:copy-of select="$value-of-template"/>
                                                    </fo:inline>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                            <fo:block/>
                            <fo:block/>
                            <fo:block/>
                        </xsl:for-each>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="footerodd">
        <fo:static-content flow-name="odd-page-footer">
            <fo:block>
                <fo:inline-container>
                    <fo:block>
                        <xsl:text>&#x2029;</xsl:text>
                    </fo:block>
                </fo:inline-container>
                <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-column column-width="150"/>
                    <fo:table-body start-indent="0pt">
                        <fo:table-row>
                            <fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
                                <fo:block/>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
                                <fo:block>
                                    <fo:block text-align="center">
                                        <fo:leader top="-37pt" leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
                                    </fo:block>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
                                <fo:block>
                                    <fo:inline font-size="8pt" font-weight="bold">
                                        <xsl:text>PHS 398 (Rev 11/07)&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Page __</xsl:text>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 9 FOR UPDATE;
buffer := '-cell font-size="smaller" padding="0" text-align="right" display-align="center">
                                <fo:block>
                                    <fo:inline font-size="8pt" font-weight="bold">
                                        <xsl:text>Form Page 2 </xsl:text>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:static-content>
    </xsl:template>
    <xsl:template name="footereven">
        <fo:static-content flow-name="even-page-footer">
            <fo:block>
                <fo:inline-container>
                    <fo:block>
                        <xsl:text>&#x2029;</xsl:text>
                    </fo:block>
                </fo:inline-container>
                <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-column column-width="150"/>
                    <fo:table-body start-indent="0pt">
                        <fo:table-row>
                            <fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
                                <fo:block/>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
                                <fo:block>
                                    <fo:block text-align="center">
                                        <fo:leader top="-37pt" leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
                                    </fo:block>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
                                <fo:block>
                                    <fo:inline font-size="8pt" font-weight="bold">
                                        <xsl:text>PHS 398 (Rev 11/07)&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Page __</xsl:text>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
                                <fo:block>
                                    <fo:inline font-size="8pt" font-weight="bold">
                                        <xsl:text>Form Page 2-continued </xsl:text>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:static-content>
    </xsl:template>
    <xsl:template name="double-backslash">
        <xsl:param name="text"/>
        <xsl:param name="text-length"/>
        <xsl:variable name="text-after-bs" select="substring-after($text, ''\'')"/>
        <xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
        <xsl:choose>
            <xsl:when test="$text-after-bs-length = 0">
                <xsl:choose>
                    <xsl:when test="substring($text, $text-length) = ''\''">
                        <xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$text"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
                <xsl:call-template name="double-backslash">
                    <xsl:with-param name="text" select="$text-after-bs"/>
                    <xsl:with-param name="text-length" select="$text-after-bs-length"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
