-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO SEQ_SPONSOR_FORM_TEMPLATES VALUES(NULL)
/
INSERT INTO SPONSOR_FORM_TEMPLATES (SPONSOR_FORM_TEMPLATE_ID,SPONSOR_FORM_ID,PAGE_NUMBER,PAGE_DESCRIPTION,FILE_NAME,CONTENT_TYPE,FORM_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_SPONSOR_FORM_TEMPLATES),(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)'),7,'Face Page','Face Page.xslt','text/xml',
'<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://era.nih.gov/Projectmgmt/SBIR/CGAP/common.namespace" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:nih="http://era.nih.gov/Projectmgmt/SBIR/CGAP/nihspecific.namespace" xmlns:phs398="http://era.nih.gov/Projectmgmt/SBIR/CGAP/phs398.namespace" xmlns:rar="http://era.nih.gov/Projectmgmt/SBIR/CGAP/researchandrelated.namespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
<xsl:param name="SV_OutputFormat" select="''PDF''"/>
<xsl:variable name="XML" select="/"/>
<xsl:variable name="fo:layout-master-set">
<fo:layout-master-set>
<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in" margin-right="0.2in">
<fo:region-body margin-top=".3in" margin-bottom="0.15in"/>
<fo:region-after extent="0.15in"/>
</fo:simple-page-master>
</fo:layout-master-set>
</xsl:variable>
<xsl:template match="/">
<fo:root>
<xsl:copy-of select="$fo:layout-master-set"/>
<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
<xsl:call-template name="footerall"/>
<fo:flow flow-name="xsl-region-body">
<fo:block>
<xsl:for-each select="$XML">
<fo:inline font-family="Verdana" font-size="8pt" line-height="9pt">
<xsl:text>Form Approved Through 11/30/2010 </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana">
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; OMB No. 0925-0001</xsl:text>
</fo:inline>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
<fo:table-column column-width="159"/>
<fo:table-column column-width="79"/>
<fo:table-column column-width="79"/>
<fo:table-column column-width="216"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell line-height="9pt" padding-top="6" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="25" text-align="center" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>Department of </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>Health and Human Services</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>Public Health Services</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="10pt" font-weight="bold">
<xsl:text>Grant Application</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" padding-top="8" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt" font-style="italic">
<xsl:text>Do not exeed character length restrictions indicated</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" margin-bottom="0" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="25" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin-bottom="0" padding="0" padding-bottom="0" padding-left="0" padding-right="0" padding-top="0" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>LEAVE BLANK-FOR PHS USE ONLY.</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell border-left-style="none" font-family="Verdana" font-size="8pt" line-height="9pt" margin-bottom="0" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Type</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" margin-bottom="0" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Activity</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-right-style="none" font-family="Verdana" font-size="8pt" line-height="9pt" margin-bottom="0" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Number</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell border-left-style="none" font-family="Verdana" font-size="8pt" line-height="9pt" margin-bottom="0" number-columns-spanned="2" border="solid 1ptgray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Review Group</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-right-style="none" font-family="Verdana" font-size="8pt" line-height="9pt" margin-bottom="0" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Formerly</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row border-bottom="0" border-bottom-style="none" border-bottom-width="0">
<fo:table-cell border-bottom-style="none" border-bottom-width="0" border-left-style="none" font-family="Verdana" font-size="8pt" line-height="9pt" margin-bottom="0" number-columns-spanned="2" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Council/Board (Month, Year)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-bottom-style="none" border-right-style="none" font-family="Verdana" font-size="8pt" line-height="9pt" margin-bottom="0" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Date Received</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" number-columns-spanned="6" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>1. TITLE OF PROJECT (Do not exceed 81 characters, including spaces and punctuation):&#160; </xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ProjectTitle">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" number-columns-spanned="6" border="solid 1pt gray" padding="0" height="35" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>2. RESPONSE TO SPECIFIC REQUEST FOR APPLICATIONS OR PROGRAM ANNOUNCEMENT OR SOLICITATION&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/FundingOpportunityDetails/FundingOpportunityResponseCode = &apos;false&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/FundingOpportunityDetails/FundingOpportunityResponseCode = &apos;true&apos;">
<fo:inline font-weight="normal">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/FundingOpportunityDetails/FundingOpportunityResponseCode =&apos;true&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>Yes</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/FundingOpportunityDetails/FundingOpportunityResponseCode = &apos;false&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="7pt" font-style="italic">
<xsl:text>(If &quot;Yes&quot;, state number and title) </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Number</xsl:text>
</fo:inline>
<fo:inline font-size="9pt">
<xsl:text>:&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="FundingOpportunityDetails">
<xsl:for-each select="FundingOpportunityNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="9pt">
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Title:</xsl:text>
</fo:inline>
<fo:inline font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="FundingOpportunityDetails">
<xsl:for-each select="FundingOpportunityTitle">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="bold">
<xsl:text>3.&#160; PRINCIPAL INVESTIGATOR/PROGRAM DIRECTOR</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" top="11pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="bold">
<xsl:text>NEW INVESTIGATOR</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/nih:ProgramDirectorPrincipalInvestigator/NewInvestigatorQuestion = &apos;false&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/nih:ProgramDirectorPrincipalInvestigator/NewInvestigatorQuestion = &apos;true&apos;">
<fo:inline font-weight="normal">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No </xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/nih:ProgramDirectorPrincipalInvestigator/NewInvestigatorQuestion = &apos;true&apos;">
<fo:inline font-weight="normal">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>Yes </xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/nih:ProgramDirectorPrincipalInvestigator/NewInvestigatorQuestion = &apos;false&apos;">
<fo:inline font-weight="normal">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>3a. NAME (Last, first, middle) </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="Name">
<xsl:for-each select="LastName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>, </xsl:text>
</fo:inline>
<xsl:for-each select="FirstName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="MiddleName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>3b. DEGREE(S)</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:if test="nih:ResearchAndRelatedProject/ProposalPerson[1]/Degree != &apos;Unknown&apos; and nih:ResearchAndRelatedProject/ProposalPerson[1]/Degree != &apos;UNKNOWN&apos;">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="nih:ResearchAndRelatedProject/ProposalPerson[1]/Degree"/>
</fo:inline>
</xsl:if>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" number-columns-spanned="2" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>3h. eRA Commons User Name</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="nih:AccountIdentifier">
<xsl:if test=". != &apos;Unknown&apos; and . != &apos;UNKNOWN&apos;">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>3c. POSITION TITLE</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="nih:ResearchAndRelatedProject/KeyPerson[1]/PositionTitle"/>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" line-height="9pt" number-columns-spanned="3" number-rows-spanned="4" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>3d. MAILING ADDRESS (Street, city, state, zip code) </xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="PostalAddress">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="Street">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</xsl:for-each>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<xsl:for-each select="City">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>, </xsl:text>
</fo:inline>
<xsl:for-each select="State">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="PostalCode">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:block>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="PostalAddress">
<xsl:for-each select="Street"/>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>E-MAIL ADDRESS: </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="Email">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>3e. DEPARTMENT, SERVICE, LABORATORY, OR EQUIVALENT</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="nih:ResearchAndRelatedProject/KeyPerson[1]/OrganizationDepartment"/>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>3f. MAJOR SUBDIVISION</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="nih:ResearchAndRelatedProject/KeyPerson[1]/OrganizationDivision"/>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline>
<xsl:text>3g. TELEPHONE AND FAX (Area code, number and extension)</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>TEL: </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="PhoneNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160;&#160; FAX: </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="FaxNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" line-height="9pt" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>4. HUMAN SUBJECTS RESEARCH</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block/>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/HumanSubjectsUsedQuestion = &apos;false&apos;">
<fo:inline>
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/HumanSubjectsUsedQuestion = &apos;true&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>No </xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/HumanSubjectsUsedQuestion =&apos;true&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="bold">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/HumanSubjectsUsedQuestion = &apos;false&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-right-style="none" line-height="9pt" number-columns-spanned="2" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>4a. RESEARCH EXEMPT</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:choose>
<xsl:when test="count(nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/ExemptionNumber ) =false()">
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="count(nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/ExemptionNumber ) = true()">
<fo:inline font-size="8pt" font-weight="normal">
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="count(nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/ExemptionNumber ) =true()">
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-family="Arial" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="count(nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/ExemptionNumber ) =false()">
<fo:inline font-size="8pt">
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:block/>
</fo:block>
</fo:table-cell>
<fo:table-cell border-left-style="none" border-left-width="0" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>If &quot;Yes&quot;, Exemption No. </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ProjectDescription">
<xsl:for-each select="nih:HumanSubject">
<xsl:for-each select="ExemptionNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" line-height="9pt" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>4b. Federal-Wide&#160; Assurance No.</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ProjectDescription">
<xsl:for-each select="nih:HumanSubject">
<xsl:for-each select="AssuranceNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="2" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>4c. Clinical Trial </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:ProjectSurvey/ClinicalTrialQuestion = &apos;false&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:ProjectSurvey/ClinicalTrialQuestion= &apos;true&apos;">
<fo:inline font-weight="normal">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:ProjectSurvey/ClinicalTrialQuestion =&apos;true&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="bold">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>Yes</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:ProjectSurvey/ClinicalTrialQuestion= &apos;false&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>4d.</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>NIH-defined Phase III Clinical Trial </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/Phase3ClinicalTrialQuestion = &apos;false&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/Phase3ClinicalTrialQuestion = &apos;true&apos;">
<fo:inline font-weight="normal">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/Phase3ClinicalTrialQuestion =&apos;true&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="bold">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>Yes</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/nih:HumanSubject/Phase3ClinicalTrialQuestion = &apos;false&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>5. VERTEBRATE ANIMAL&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:AnimalSubject/VertebrateAnimalsUsedQuestion = &apos;false&apos;">
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:AnimalSubject/VertebrateAnimalsUsedQuestion = &apos;true&apos;">
<fo:inline font-weight="normal">
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>No</xsl:text>
</fo:inline>
<fo:inline font-weight="normal">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:AnimalSubject/VertebrateAnimalsUsedQuestion =&apos;true&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
<fo:inline font-weight="bold">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-weight="normal">
<xsl:text>Yes</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</xsl:when>
<xsl:when test="nih:ResearchAndRelatedProject/nih:ProjectDescription/rar:AnimalSubject/VertebrateAnimalsUsedQuestion = &apos;false&apos;">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Yes</xsl:text>
</fo:inline>
</xsl:when>
</xsl:choose>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>5a. Animal welfare assurance no&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ProjectDescription">
<xsl:for-each select="rar:AnimalSubject">
<xsl:for-each select="AssuranceNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell border-bottom-style="none" line-height="9pt" border="solid 1pt gray" padding="0" height="31" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>6. DATES OF PROPOSED PERIOD OF SUPPORT</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="2" border="solid 1pt gray" padding="0" height="31" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>7. CO</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>STS REQ</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>UES</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>TED FOR I</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>N</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>ITIAL BUDG</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>ET PERIOD</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="31" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>8. COSTS REQUESTED FOR PROPOSED PERIOD OF SUPPORT</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell border-top-style="none" line-height="9pt" border="solid 1pt gray" padding="0" height="19" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>From</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ProjectDates">
<xsl:for-each select="ProjectStartDate">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Through</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="7pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="ProjectEndDate">
<fo:inline font-family="Verdana" font-size="9pt" font-style="normal" font-weight="normal">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:block>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="9pt" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block font-size="9pt" line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>7a. Direct Costs</xsl:text>
</fo:inline>
<fo:block/>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/BudgetSummary/ModularBudgetQuestion = &apos;false&apos;">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/PeriodDirectCostsTotal - nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/ConsortiumCosts/IndirectCosts), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" line-height="9pt">
<xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ModularPeriodAmount [../BudgetPeriodID=1] - nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ConsortiumCosts/IndirectCosts [../../BudgetPeriodID=1]), ''###,###,##0'')"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>7b. Total Costs</xsl:text>
</fo:inline>
<fo:block/>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/BudgetSummary/ModularBudgetQuestion = &apos;true&apos;">
<fo:inline font-size="9pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="9pt" line-height="9pt">
<xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/IndirectCostsTotal +
nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/ModularPeriodAmount), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:for-each select="PeriodCostsTotal">
<xsl:if test="../BudgetPeriodID =1">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="9pt" line-height="9pt" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block font-size="9pt" line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>8a. Direct Costs</xsl:text>
</fo:inline>
<fo:block/>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/BudgetSummary/ModularBudgetQuestion = &apos;false&apos;">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/PeriodDirectCostsTotal ) - sum( nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ConsortiumCosts/IndirectCosts)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ModularPeriodAmount)- sum( nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ConsortiumCosts/IndirectCosts)), ''###,###,##0'')"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" line-height="9pt" number-columns-spanned="2" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>8b. Total Costs</xsl:text>
</fo:inline>
<fo:block/>
<xsl:choose>
<xsl:when test="nih:ResearchAndRelatedProject/BudgetSummary/ModularBudgetQuestion =&apos;true&apos;">
<fo:inline font-size="9pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(sum( nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/ModularPeriodAmount ) +
nih:ResearchAndRelatedProject/BudgetSummary/BudgetIndirectCostsTotal), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetCostsTotal">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" number-columns-spanned="3" number-rows-spanned="2" border="solid 1pt gray" padding="0" height="13" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>9. APPLICANT ORGANIZATION&#160; </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Name&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<xsl:for-each select="OrganizationName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text> Address&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<xsl:for-each select="OrganizationAddress">
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="Street">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</xsl:for-each>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="City">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline>
<xsl:text>, </xsl:text>
</fo:inline>
<xsl:for-each select="State">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="PostalCode">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:block>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>10. TYPE OF ORGANIZATION</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Public: --&gt;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode = 3 
or nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode =8">
<fo:inline font-family="Verdana" font-size="10pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160; Federal&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode = 2
or nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode =21">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline>
<xsl:text>&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>State&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode &gt; 21 and
nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode &lt; 27">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt" width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline>
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Local&#160; </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Private: --&gt;</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode = 4 or nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode =5
or nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode =10">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160; Private Nonprofit </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>For-profit: --&gt;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode =6 
or nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode =7
or nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode =9">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160; General&#160; </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode = 11">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160; Business&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode = 11">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Small Business&#160; </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode = 15">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Woman-owned</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/ApplicantOrganization/OrganizationClassification/CategoryCode = 14">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="ZapfDingbats" font-size="10pt " width="19px"> 
<xsl:text>&#x2714;</xsl:text>
</fo:inline>
</xsl:if>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Socially and Economically Disadvantaged</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="10pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="19" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>11. ENTITY IDENTIFICATION NUMBER: </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<xsl:for-each select="PHSAccountID">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="10pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>DUNS NO.&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="OrganizationDUNS">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="10pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Congressional District:&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="OrganizationCongressionalDistrict">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:block>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="13" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>12. ADMINISTRATIVE OFFICIAL TO BE NOTIFIED IF AWARD IS MADE </xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Name:&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<xsl:for-each select="OrganizationContactPerson">
<xsl:for-each select="Name">
<fo:inline font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="FirstName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="LastName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Title</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:text>:&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="PositionTitle">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Address</xsl:text>
</fo:inline>
<fo:inline font-size="9pt">
<xsl:text>:&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="ContactInformation">
<xsl:for-each select="PostalAddress">
<xsl:for-each select="Street">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</xsl:for-each>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="City">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-size="9pt">
<xsl:text>, </xsl:text>
</fo:inline>
<xsl:for-each select="State">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline font-size="9pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="PostalCode">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:block>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:block>
</fo:block>
</fo:block>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Tel:&#160; </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<xsl:for-each select="OrganizationContactPerson">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="PhoneNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>FAX:</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<xsl:for-each select="OrganizationContactPerson">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="FaxNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>E-Mail:&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="ApplicantOrganization">
<xsl:for-each select="OrganizationContactPerson">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="Email">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="13" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>13. OFFICIAL SIGNING FOR APPLICANT ORGANIZATION </xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Name:&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="AuthorizedOrganizationalRepresentative">
<xsl:for-each select="Name">
<xsl:for-each select="FirstName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="LastName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Title: </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="PositionTitle">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<xsl:for-each select="ContactInformation">
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Address:&#160; </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="PostalAddress">
<xsl:for-each select="Street">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</fo:block>
</fo:block>
</xsl:for-each>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="City">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline>
<xsl:text>, </xsl:text>
</fo:inline>
<xsl:for-each select="State">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="PostalCode">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:block>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:block>
</xsl:for-each>
</fo:block>
</fo:block>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Tel:&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="AuthorizedOrganizationalRepresentative">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="PhoneNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; FAX:&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="AuthorizedOrganizationalRepresentative">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="FaxNumber">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>E-Mail</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>:</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="nih:ResearchCoverPage">
<xsl:for-each select="AuthorizedOrganizationalRepresentative">
<xsl:for-each select="ContactInformation">
<xsl:for-each select="Email">
<fo:inline>
<xsl:text>&#160; </xsl:text>
</fo:inline>
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="143" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>14. APPLICANT ORGANIZATION CERTIFICATION AND ACCEPTANCE: </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="7pt">
<xsl:text>I certify that the statements herein are true, complete and accurate to the best of my knowledge, and accept the obligation to comply with Public Health Services terms and conditions if a grant is awarded as a result of this application. I am aware that any false, fictitious, or fraudulent statements or claims may subject me to criminal, civil, or administrative penalties. </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" font-weight="normal" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="143" text-align="left" display-align="before">
<fo:block>
<fo:inline font-family="Verdana" font-size="7pt">
<xsl:text>SIGNATURE OF OFFICIAL NAMED IN 13.</xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="7pt" font-style="italic">
<xsl:text>(In ink. &quot;Per&quot; signature not acceptable.)&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block/>
</fo:block>
</fo:block>
</fo:block>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>Date</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="7pt" font-style="italic">
<xsl:text>&#160; </xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:inline font-family="Verdana" font-size="7pt" font-style="italic">
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="7pt" font-style="italic">
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline>
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline font-family="Verdana" font-size="7pt">
<xsl:text>PHS 398 (rev. 11/07)&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Face Page&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="7pt" font-weight="bold">
<xsl:text>Form Page 1</xsl:text>
</fo:inline>
</xsl:for-each>
</fo:block>
<fo:block id="SV_RefID_PageTotal"/>
</fo:flow>
</fo:page-sequence>
</fo:root>
</xsl:template>
<xsl:template name="footerall">
<fo:static-content flow-name="xsl-region-after">
<fo:block>
<xsl:for-each select="$XML"/>
</fo:block>
</fo:static-content>
</xsl:template>
<xsl:template name="double-backslash">
<xsl:param name="text"/>
<xsl:param name="text-length"/>
<xsl:variable name="text-after-bs" select="substring-after($text, '''')"/>
<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
<xsl:choose>
<xsl:when test="$text-after-bs-length = 0">
<xsl:choose>
<xsl:when test="substring($text, $text-length) = ''''">
<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\'\\\'\')"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$text"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\'\\\'\')"/>
<xsl:call-template name="double-backslash">
<xsl:with-param name="text" select="$text-after-bs"/>
<xsl:with-param name="text-length" select="$text-after-bs-length"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
</xsl:stylesheet>','admin',NOW(),UUID(),1)
/
DELIMITER ;
